/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.orderingList;

import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.common.picker.MultipleChoicePicker;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.orderingList.OrderingInteraction;
import org.richfaces.fragment.orderingList.OrderingList;
import org.richfaces.fragment.orderingList.PuttingSelectedItem;
import org.richfaces.fragment.orderingList.SelectableListItem;

public abstract class AbstractOrderingList
implements OrderingList,
AdvancedInteractions<AdvancedOrderingListInteractions> {
    @Root
    private WebElement root;
    @Drone
    private WebDriver driver;
    private final AdvancedOrderingListInteractions interactions = new AdvancedOrderingListInteractions();
    private final OrderingInteraction orderingInteraction = new OrderingInteractionImpl();
    private final PuttingSelectedItem puttingSelectedItem = new PuttingSelectedItemImpl();

    @Override
    public AdvancedOrderingListInteractions advanced() {
        return this.interactions;
    }

    protected abstract OrderingListBodyElements getBody();

    protected WebElement getRoot() {
        return this.root;
    }

    @Override
    public PuttingSelectedItem select(String visibleText) {
        return this.select(ChoicePickerHelper.byVisibleText().match(visibleText));
    }

    @Override
    public PuttingSelectedItem select(Integer index) {
        return this.select(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PuttingSelectedItem select(ChoicePicker picker) {
        this.unselectAll();
        this.selectItem(picker.pick(this.getBody().getItemsElements()));
        return this.puttingSelectedItem;
    }

    protected void selectItem(final WebElement item) {
        new Actions(this.driver).keyDown(Keys.CONTROL).click(item).keyUp(Keys.CONTROL).addAction(new Action(){

            public void perform() {
                Graphene.waitGui().until().element(item).attribute("class").contains(AbstractOrderingList.this.getBody().getStyleForSelectedItem());
            }
        }).perform();
    }

    protected void selectItems(List<WebElement> list) {
        for (WebElement webElement : list) {
            this.selectItem(webElement);
        }
    }

    protected void unselectAll() {
        if (!this.getBody().getSelectedItems().isEmpty()) {
            new Actions(this.driver).click(this.getBody().getItemsElements().get(0)).keyDown(Keys.CONTROL).click(this.getBody().getItemsElements().get(0)).keyUp(Keys.CONTROL).addAction(new Action(){

                public void perform() {
                    ((StringMatcher)Graphene.waitGui().until().element(AbstractOrderingList.this.getBody().getItemsElements().get(0)).attribute("class").not()).contains("rf-ord-sel");
                }
            }).perform();
            if (!this.getBody().getSelectedItems().isEmpty()) {
                throw new RuntimeException("The unselection was not successfull.");
            }
        }
    }

    public static interface OrderingListBodyElements {
        public WebElement getBottomButtonElement();

        public WebElement getCaptionElement();

        public WebElement getDownButtonElement();

        public WebElement getHeaderElement();

        public List<WebElement> getItemsElements();

        public ListComponent<? extends SelectableListItem> getList();

        public WebElement getListAreaElement();

        public WebElement getRootElement();

        public List<WebElement> getSelectedItems();

        public WebElement getTopButtonElement();

        public WebElement getUpButtonElement();

        public String getStyleForSelectedItem();
    }

    public class AdvancedOrderingListInteractions {
        public WebElement getBottomButtonElement() {
            return AbstractOrderingList.this.getBody().getBottomButtonElement();
        }

        public WebElement getCaptionElement() {
            return AbstractOrderingList.this.getBody().getCaptionElement();
        }

        public WebElement getDownButtonElement() {
            return AbstractOrderingList.this.getBody().getDownButtonElement();
        }

        public WebElement getHeaderElement() {
            return AbstractOrderingList.this.getBody().getHeaderElement();
        }

        public List<WebElement> getItemsElements() {
            return AbstractOrderingList.this.getBody().getItemsElements();
        }

        public ListComponent<? extends SelectableListItem> getList() {
            return AbstractOrderingList.this.getBody().getList();
        }

        public WebElement getListAreaElement() {
            return AbstractOrderingList.this.getBody().getListAreaElement();
        }

        public WebElement getRootElement() {
            return AbstractOrderingList.this.getBody().getRootElement();
        }

        public List<WebElement> getSelectedItemsElements() {
            return AbstractOrderingList.this.getBody().getSelectedItems();
        }

        public WebElement getTopButtonElement() {
            return AbstractOrderingList.this.getBody().getTopButtonElement();
        }

        public WebElement getUpButtonElement() {
            return AbstractOrderingList.this.getBody().getUpButtonElement();
        }

        public OrderingInteraction select(String visibleText, String ... otherTexts) {
            ChoicePickerHelper.ByVisibleTextChoicePicker picker = ChoicePickerHelper.byVisibleText().allRulesMustPass(false).match(visibleText);
            for (String string : otherTexts) {
                picker.match(string);
            }
            return this.select(picker);
        }

        public OrderingInteraction select(Integer index, Integer ... otherIndexes) {
            ChoicePickerHelper.ByIndexChoicePicker picker = ChoicePickerHelper.byIndex().index(index);
            for (Integer integer : otherIndexes) {
                picker.index(integer);
            }
            return this.select(picker);
        }

        public OrderingInteraction select(MultipleChoicePicker picker) {
            AbstractOrderingList.this.unselectAll();
            AbstractOrderingList.this.selectItems(picker.pickMultiple(AbstractOrderingList.this.getBody().getItemsElements()));
            return AbstractOrderingList.this.orderingInteraction;
        }
    }

    private class OrderingInteractionImpl
    implements OrderingInteraction {
        private OrderingInteractionImpl() {
        }

        private void checkIfActionPosibleAndPerform(WebElement button, int times) {
            if (!button.isEnabled()) {
                throw new RuntimeException("No items are selected or button is disabled.");
            }
            for (int i = 0; i < times; ++i) {
                button.click();
            }
        }

        @Override
        public void bottom() {
            this.checkIfActionPosibleAndPerform(AbstractOrderingList.this.getBody().getBottomButtonElement(), 1);
        }

        @Override
        public void down(int times) {
            this.checkIfActionPosibleAndPerform(AbstractOrderingList.this.getBody().getDownButtonElement(), times);
        }

        @Override
        public void top() {
            this.checkIfActionPosibleAndPerform(AbstractOrderingList.this.getBody().getTopButtonElement(), 1);
        }

        @Override
        public void up(int times) {
            this.checkIfActionPosibleAndPerform(AbstractOrderingList.this.getBody().getUpButtonElement(), times);
        }
    }

    private class PuttingSelectedItemImpl
    implements PuttingSelectedItem {
        private PuttingSelectedItemImpl() {
        }

        private OrderingList putAction(int positionSource, int positionTarget, int differenceToEnd) {
            if (positionSource != positionTarget) {
                int differenceBetween = positionTarget - positionSource;
                int absBetween = Math.abs(differenceBetween);
                int min = Math.min(absBetween, Math.min(positionTarget, differenceToEnd));
                if (min == absBetween) {
                    this.singleStepMove(differenceBetween);
                } else if (min == positionTarget) {
                    AbstractOrderingList.this.orderingInteraction.top();
                    if (positionTarget != 0) {
                        this.singleStepMove(positionTarget);
                    }
                } else {
                    AbstractOrderingList.this.orderingInteraction.bottom();
                    if (differenceToEnd != 0) {
                        this.singleStepMove(-differenceToEnd);
                    }
                }
            }
            return AbstractOrderingList.this;
        }

        @Override
        public OrderingList putItAfter(ChoicePicker picker) {
            int indexOfTargetItem = Utils.getIndexOfElement(picker.pick(AbstractOrderingList.this.getBody().getItemsElements())) + 1;
            return this.putAction(Utils.getIndexOfElement(AbstractOrderingList.this.getBody().getSelectedItems().get(0)), indexOfTargetItem, AbstractOrderingList.this.getBody().getItemsElements().size() - indexOfTargetItem);
        }

        @Override
        public OrderingList putItAfter(int index) {
            return this.putItAfter(ChoicePickerHelper.byIndex().index(index));
        }

        @Override
        public OrderingList putItAfter(String match) {
            return this.putItAfter(ChoicePickerHelper.byVisibleText().match(match));
        }

        @Override
        public OrderingList putItBefore(ChoicePicker picker) {
            int indexOfTargetItem = Utils.getIndexOfElement(picker.pick(AbstractOrderingList.this.getBody().getItemsElements()));
            return this.putAction(Utils.getIndexOfElement(AbstractOrderingList.this.getBody().getSelectedItems().get(0)), indexOfTargetItem, AbstractOrderingList.this.getBody().getItemsElements().size() - indexOfTargetItem);
        }

        @Override
        public OrderingList putItBefore(int index) {
            return this.putItBefore(ChoicePickerHelper.byIndex().index(index));
        }

        @Override
        public OrderingList putItBefore(String match) {
            return this.putItBefore(ChoicePickerHelper.byVisibleText().match(match));
        }

        private void singleStepMove(int difference) {
            if (difference != 0) {
                if (difference > 0) {
                    AbstractOrderingList.this.orderingInteraction.down(Math.abs(difference));
                } else {
                    AbstractOrderingList.this.orderingInteraction.up(Math.abs(difference));
                }
            }
        }
    }
}

