/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.panelMenu;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.condition.element.WebElementConditionFactory;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.ErrorHandler;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Event;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.panelMenu.PanelMenu;
import org.richfaces.fragment.panelMenu.PanelMenuGroup;
import org.richfaces.fragment.panelMenu.PanelMenuItem;
import org.richfaces.fragment.panelMenu.RichFacesPanelMenuGroup;
import org.richfaces.fragment.panelMenu.RichFacesPanelMenuItem;

public abstract class AbstractPanelMenu
implements PanelMenu,
PanelMenuGroup,
AdvancedInteractions<AdvancedAbstractPanelMenuInteractions> {
    public static final String CSS_EXPANDED_SUFFIX = "-exp";
    public static final String CSS_TRANSPARENT_SUFFIX = "-transparent";
    public static final String CSS_SELECTED_SUFFIX = "-sel";
    public static final String CSS_HOVERED_SUFFIX = "-hov";
    public static final String CSS_DISABLED_SUFFIX = "-dis";
    public static final String CSS_COLLAPSED_SUFFIX = "-colps";
    private static final String HEADER_SELECTOR_TO_INVOKE_EVENT_ON = "div[class*=rf-pm-][class*=-gr-hdr]";
    @ArquillianResource
    private JavascriptExecutor executor;
    @Drone
    private WebDriver browser;
    private final AdvancedAbstractPanelMenuInteractions advancedInteractions = new AdvancedAbstractPanelMenuInteractions();
    private Event expandEvent = Event.CLICK;
    private Event collapseEvent = Event.CLICK;

    @Override
    public PanelMenuItem selectItem(ChoicePicker picker) {
        WebElement itemRoot = picker.pick(this.getMenuItems());
        this.ensureElementExist(itemRoot);
        this.ensureElementIsEnabledAndVisible(itemRoot);
        RichFacesPanelMenuItem panelMenuItem = (RichFacesPanelMenuItem)Graphene.createPageFragment(RichFacesPanelMenuItem.class, (WebElement)itemRoot);
        panelMenuItem.select();
        return panelMenuItem;
    }

    @Override
    public PanelMenuItem selectItem(String header) {
        return this.selectItem(ChoicePickerHelper.byVisibleText().match(header));
    }

    @Override
    public PanelMenuItem selectItem(int index) {
        return this.selectItem(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PanelMenuGroup expandGroup(ChoicePicker picker) {
        WebElement groupRoot = picker.pick(this.getMenuGroups());
        this.ensureElementExist(groupRoot);
        this.ensureElementIsEnabledAndVisible(groupRoot);
        WebElement groupHeader = this.getHeaderElementDynamically(groupRoot);
        if (this.isGroupExpanded(groupHeader)) {
            return (PanelMenuGroup)Graphene.createPageFragment(RichFacesPanelMenuGroup.class, (WebElement)groupRoot);
        }
        this.executeEventOn(this.expandEvent, groupHeader);
        this.advanced().waitUntilMenuGroupExpanded(groupHeader).perform();
        return (PanelMenuGroup)Graphene.createPageFragment(RichFacesPanelMenuGroup.class, (WebElement)groupRoot);
    }

    @Override
    public PanelMenuGroup expandGroup(String header) {
        return this.expandGroup(ChoicePickerHelper.byVisibleText().startsWith(header));
    }

    @Override
    public PanelMenuGroup expandGroup(int index) {
        return this.expandGroup(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public void collapseGroup(ChoicePicker picker) {
        WebElement groupRoot = picker.pick(this.getMenuGroups());
        this.ensureElementExist(groupRoot);
        this.ensureElementIsEnabledAndVisible(groupRoot);
        WebElement groupHeader = this.getHeaderElementDynamically(groupRoot);
        if (!this.isGroupExpanded(groupHeader)) {
            return;
        }
        this.executeEventOn(this.collapseEvent, groupHeader);
        this.advanced().waitUntilMenuGroupCollapsed(groupHeader).perform();
    }

    @Override
    public void collapseGroup(String header) {
        this.collapseGroup(ChoicePickerHelper.byVisibleText().startsWith(header));
    }

    @Override
    public void collapseGroup(int index) {
        this.collapseGroup(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PanelMenu expandAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PanelMenu collapseAll() {
        throw new UnsupportedOperationException();
    }

    public abstract List<WebElement> getMenuItems();

    public abstract List<WebElement> getMenuGroups();

    @Override
    public AdvancedAbstractPanelMenuInteractions advanced() {
        return this.advancedInteractions;
    }

    private boolean isGroupExpanded(WebElement groupHeader) {
        return groupHeader.getAttribute("class").contains(CSS_EXPANDED_SUFFIX);
    }

    private void ensureElementIsEnabledAndVisible(WebElement element) {
        this.checkElementIsVisible(element);
        if (this.isDisabled(element)) {
            throw new IllegalArgumentException("Element " + element + " can not be interacted with, as it is disabled.");
        }
    }

    private boolean isDisabled(WebElement group) {
        return group.getAttribute("class").contains(CSS_DISABLED_SUFFIX);
    }

    private void checkElementIsVisible(WebElement element) {
        if (!((Boolean)new WebElementConditionFactory(element).isVisible().apply((Object)this.browser)).booleanValue()) {
            throw new IllegalArgumentException("Element: " + element + " must be visible before interacting with it!");
        }
    }

    private void executeEventOn(Event event, WebElement element) {
        Utils.triggerJQ(this.executor, event.getEventName(), element);
    }

    private WebElement getHeaderElementDynamically(WebElement element) {
        return element.findElement(By.cssSelector((String)HEADER_SELECTOR_TO_INVOKE_EVENT_ON));
    }

    private void ensureElementExist(WebElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Group/item must exist!");
        }
    }

    public class AdvancedAbstractPanelMenuInteractions {
        private long _timoutForMenuGroupToBeExpanded = -1L;
        private long _timeoutForMenuGroupToBeCollapsed = -1L;

        public void setupExpandEvent(Event event) {
            AbstractPanelMenu.this.expandEvent = event;
        }

        public void setupCollapseEvent(Event event) {
            AbstractPanelMenu.this.collapseEvent = event;
        }

        public boolean isGroupExpanded(WebElement groupRoot) {
            return AbstractPanelMenu.this.isGroupExpanded(AbstractPanelMenu.this.getHeaderElementDynamically(groupRoot));
        }

        public WaitingWrapper waitUntilMenuGroupExpanded(final WebElement groupHeader) {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.ignoring(ErrorHandler.UnknownServerException.class).until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AbstractPanelMenu.this.isGroupExpanded(groupHeader);
                        }
                    });
                }
            }.withMessage("Waiting for Panel Menu group to be expanded!").withTimeout(this.getTimoutForMenuGroupToBeExpanded(), TimeUnit.MILLISECONDS);
        }

        public WaitingWrapper waitUntilMenuGroupCollapsed(final WebElement groupHeader) {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.ignoring(ErrorHandler.UnknownServerException.class).until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AbstractPanelMenu.this.isGroupExpanded(groupHeader);
                        }
                    });
                }
            }.withMessage("Waiting for Panel Menu group to be expanded!").withTimeout(this.getTimeoutForMenuGroupToBeCollapsed(), TimeUnit.MILLISECONDS);
        }

        public void setupTimoutForMenuGroupToBeExpanded(long timeoutInMilliseconds) {
            this._timoutForMenuGroupToBeExpanded = timeoutInMilliseconds;
        }

        public long getTimoutForMenuGroupToBeExpanded() {
            return this._timoutForMenuGroupToBeExpanded == -1L ? Utils.getWaitAjaxDefaultTimeout(AbstractPanelMenu.this.browser) : this._timoutForMenuGroupToBeExpanded;
        }

        public void setupTimeoutForMenuGroupToBeCollapsed(long timeoutInMilliseconds) {
            this._timeoutForMenuGroupToBeCollapsed = timeoutInMilliseconds;
        }

        public long getTimeoutForMenuGroupToBeCollapsed() {
            return this._timeoutForMenuGroupToBeCollapsed == -1L ? Utils.getWaitAjaxDefaultTimeout(AbstractPanelMenu.this.browser) : this._timeoutForMenuGroupToBeCollapsed;
        }
    }
}

