/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.pickList;

import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.common.picker.MultipleChoicePicker;
import org.richfaces.fragment.list.AbstractListComponent;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.orderingList.AbstractOrderingList;
import org.richfaces.fragment.orderingList.AbstractSelectableListItem;
import org.richfaces.fragment.orderingList.OrderingList;
import org.richfaces.fragment.orderingList.SelectableListItem;
import org.richfaces.fragment.pickList.PickList;

public class RichFacesPickList
implements PickList,
AdvancedInteractions<AdvancedPickListInteractions> {
    @Root
    private WebElement root;
    @Drone
    private WebDriver driver;
    @FindBy(className="rf-pick-add-all")
    private WebElement addAllButtonElement;
    @FindBy(className="rf-pick-add")
    private WebElement addButtonElement;
    @FindBy(className="rf-pick-rem-all")
    private WebElement removeAllButtonElement;
    @FindBy(className="rf-pick-rem")
    private WebElement removeButtonElement;
    @FindBy(css="[id$='SourceItems'] > .rf-pick-sel")
    private List<WebElement> selectedSourceListItems;
    @FindBy(css="[id$='SourceItems'] > *")
    private List<WebElement> sourceListItems;
    @FindBy(css="[id$='TargetItems'] > .rf-pick-sel")
    private List<WebElement> selectedTargetListItems;
    @FindBy(css="[id$='TargetItems'] > *")
    private List<WebElement> targetListItems;
    @FindBy(css="[id$='SourceItems']")
    private SelectableListImpl sourceList;
    @FindBy(css="[id$='Target']")
    private OrderingListInPickList targetList;
    @FindBy(className="rf-pick-lst-scrl")
    private WebElement listAreaElement;
    @FindBy(className="rf-pick-src-cptn")
    private WebElement captionElement;
    @FindBy(css="thead.rf-pick-lst-hdr > tr.rf-pick-hdr")
    private WebElement headerElement;
    private final AdvancedPickListInteractions interactions = new AdvancedPickListInteractions();

    @Override
    public AdvancedPickListInteractions advanced() {
        return this.interactions;
    }

    private void clickAddAllButton() {
        this.addAllButtonElement.click();
    }

    private void clickAddButton() {
        this.addButtonElement.click();
    }

    private void clickRemoveAllButton() {
        this.removeAllButtonElement.click();
    }

    private void clickRemoveButton() {
        this.removeButtonElement.click();
    }

    @Override
    public PickList add(ChoicePicker picker) {
        this.selectAndAdd(picker);
        return this;
    }

    @Override
    public PickList add(String match) {
        return this.add(ChoicePickerHelper.byVisibleText().match(match));
    }

    @Override
    public PickList add(int index) {
        return this.add(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PickList addMultiple(MultipleChoicePicker picker) {
        this.selectAndAddMultiple(picker);
        return this;
    }

    @Override
    public PickList addAll() {
        this.clickAddAllButton();
        return this;
    }

    @Override
    public PickList remove(ChoicePicker picker) {
        this.selectAndRemove(picker);
        return this;
    }

    @Override
    public PickList remove(String match) {
        return this.remove(ChoicePickerHelper.byVisibleText().match(match));
    }

    @Override
    public PickList remove(int index) {
        return this.remove(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PickList removeMultiple(MultipleChoicePicker picker) {
        this.selectAndRemoveMultiple(picker);
        return this;
    }

    @Override
    public PickList removeAll() {
        this.clickRemoveAllButton();
        return this;
    }

    private void selectAndAdd(ChoicePicker picker) {
        this.unselectAll(this.selectedSourceListItems);
        this.selectItem(picker.pick(this.sourceListItems));
        this.clickAddButton();
    }

    private void selectAndAddMultiple(MultipleChoicePicker picker) {
        this.unselectAll(this.selectedSourceListItems);
        for (WebElement item : picker.pickMultiple(this.sourceListItems)) {
            this.selectItem(item);
        }
        this.clickAddButton();
    }

    private void selectAndRemove(ChoicePicker picker) {
        this.unselectAll(this.selectedTargetListItems);
        this.selectItem(picker.pick(this.targetListItems));
        this.clickRemoveButton();
    }

    private void selectAndRemoveMultiple(MultipleChoicePicker picker) {
        this.unselectAll(this.selectedTargetListItems);
        for (WebElement item : picker.pickMultiple(this.targetListItems)) {
            this.selectItem(item);
        }
        this.clickRemoveButton();
    }

    private void selectItem(final WebElement item) {
        new Actions(this.driver).keyDown(Keys.CONTROL).click(item).keyUp(Keys.CONTROL).addAction(new Action(){

            public void perform() {
                Graphene.waitGui().until().element(item).attribute("class").contains("rf-pick-sel");
            }
        }).perform();
    }

    protected void unselectAll(List<WebElement> list) {
        if (!list.isEmpty()) {
            new Actions(this.driver).click(list.get(0)).keyDown(Keys.CONTROL).click(list.get(0)).keyUp(Keys.CONTROL).perform();
            if (!list.isEmpty()) {
                throw new RuntimeException("The unselection was not successfull.");
            }
        }
    }

    public static class SelectableListImpl
    extends AbstractListComponent<SelectableListItemImpl> {
    }

    public class AdvancedPickListInteractions {
        public WebElement getAddAllButtonElement() {
            return RichFacesPickList.this.addAllButtonElement;
        }

        public WebElement getAddButtonElement() {
            return RichFacesPickList.this.addButtonElement;
        }

        public WebElement getBottomButtonElement() {
            return RichFacesPickList.this.targetList.getBottomButtonElement();
        }

        public WebElement getSourceCaptionElement() {
            return RichFacesPickList.this.captionElement;
        }

        public WebElement getTargetCaptionElement() {
            return RichFacesPickList.this.targetList.getCaptionElement();
        }

        public WebElement getDownButtonElement() {
            return RichFacesPickList.this.targetList.getDownButtonElement();
        }

        public WebElement getSourceHeaderElement() {
            return RichFacesPickList.this.headerElement;
        }

        public WebElement getTargetHeaderElement() {
            return RichFacesPickList.this.targetList.getHeaderElement();
        }

        public WebElement getSourceListAreaElement() {
            return RichFacesPickList.this.listAreaElement;
        }

        public WebElement getTargetListAreaElement() {
            return RichFacesPickList.this.targetList.getListAreaElement();
        }

        public WebElement getRemoveAllButtonElement() {
            return RichFacesPickList.this.removeAllButtonElement;
        }

        public WebElement getRemoveButtonElement() {
            return RichFacesPickList.this.removeButtonElement;
        }

        public WebElement getRootElement() {
            return RichFacesPickList.this.root;
        }

        public ListComponent<? extends SelectableListItem> getSourceList() {
            return RichFacesPickList.this.sourceList;
        }

        public ListComponent<? extends SelectableListItem> getTargetList() {
            return RichFacesPickList.this.targetList.getList();
        }

        public WebElement getTopButtonElement() {
            return RichFacesPickList.this.targetList.getTopButtonElement();
        }

        public WebElement getUpButtonElement() {
            return RichFacesPickList.this.targetList.getUpButtonElement();
        }

        public OrderingList orderTargetList() {
            return RichFacesPickList.this.targetList;
        }
    }

    public static class SelectableListItemImpl
    extends AbstractSelectableListItem {
        private static final String SELECTED_ITEM_CLASS = "rf-pick-sel";

        @Override
        protected String getStyleClassForSelectedItem() {
            return SELECTED_ITEM_CLASS;
        }
    }

    public static class OrderingListInPickList
    extends AbstractOrderingList
    implements AbstractOrderingList.OrderingListBodyElements {
        private static final String SELECTED_ITEM_CLASS = "rf-pick-sel";
        @FindBy(css="button.rf-ord-dn")
        private WebElement downButtonElement;
        @FindBy(css="button.rf-ord-up-tp")
        private WebElement topButtonElement;
        @FindBy(css="button.rf-ord-dn-bt")
        private WebElement bottomButtonElement;
        @FindBy(css="button.rf-ord-up")
        private WebElement upButtonElement;
        @FindBy(css="thead.rf-pick-lst-hdr > tr.rf-pick-hdr")
        private WebElement headerElement;
        @FindBy(className="rf-pick-tgt-cptn")
        private WebElement captionElement;
        @FindBy(className="rf-pick-opt")
        private List<WebElement> items;
        @FindBy(className="rf-pick-sel")
        private List<WebElement> selectedItems;
        @FindBy(className="rf-pick-lst-scrl")
        private WebElement listAreaElement;
        @FindBy(css="[id$='TargetItems']")
        private SelectableListImpl list;

        @Override
        protected AbstractOrderingList.OrderingListBodyElements getBody() {
            return this;
        }

        @Override
        public WebElement getBottomButtonElement() {
            return this.bottomButtonElement;
        }

        @Override
        public WebElement getCaptionElement() {
            return this.captionElement;
        }

        @Override
        public WebElement getDownButtonElement() {
            return this.downButtonElement;
        }

        @Override
        public WebElement getHeaderElement() {
            return this.headerElement;
        }

        @Override
        public List<WebElement> getItemsElements() {
            return Collections.unmodifiableList(this.items);
        }

        @Override
        public ListComponent<? extends SelectableListItem> getList() {
            return this.list;
        }

        @Override
        public WebElement getListAreaElement() {
            return this.listAreaElement;
        }

        @Override
        public WebElement getRootElement() {
            return this.getRoot();
        }

        @Override
        public List<WebElement> getSelectedItems() {
            return Collections.unmodifiableList(this.selectedItems);
        }

        @Override
        public String getStyleForSelectedItem() {
            return SELECTED_ITEM_CLASS;
        }

        @Override
        public WebElement getTopButtonElement() {
            return this.topButtonElement;
        }

        @Override
        public WebElement getUpButtonElement() {
            return this.upButtonElement;
        }
    }
}

