/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.switchable;

import com.google.common.base.Predicate;
import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.TypeResolver;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.switchable.ComponentContainer;
import org.richfaces.fragment.switchable.SwitchType;
import org.richfaces.fragment.switchable.SwitchableComponent;

public abstract class AbstractSwitchableComponent<T extends ComponentContainer>
implements SwitchableComponent<T>,
AdvancedInteractions<AdvancedSwitchableComponentInteractions> {
    @Root
    private WebElement root;
    private final Class<T> containerClass = TypeResolver.resolveRawArgument(SwitchableComponent.class, this.getClass());

    protected abstract WebElement getRootOfContainerElement();

    protected abstract List<WebElement> getSwitcherControllerElements();

    @Override
    public T switchTo(ChoicePicker picker) {
        WebElement switcher = picker.pick(this.getSwitcherControllerElements());
        if (switcher == null) {
            throw new IllegalArgumentException("No such item which fulfill the conditions from picker: " + picker);
        }
        this.switchTo(switcher);
        return (T)((ComponentContainer)Graphene.createPageFragment(this.containerClass, (WebElement)this.getRootOfContainerElement()));
    }

    @Override
    public T switchTo(String header) {
        return this.switchTo(ChoicePickerHelper.byVisibleText().match(header));
    }

    @Override
    public T switchTo(int index) {
        return this.switchTo(ChoicePickerHelper.byIndex().index(index));
    }

    private void switchTo(WebElement switcher) {
        String textToContain = switcher.getText();
        switch (((AdvancedSwitchableComponentInteractions)this.advanced()).getSwitchType()) {
            case CLIENT: {
                switcher.click();
                break;
            }
            case AJAX: {
                ((WebElement)Graphene.guardAjax((Object)switcher)).click();
                break;
            }
            case SERVER: {
                ((WebElement)Graphene.guardHttp((Object)switcher)).click();
            }
        }
        ((AdvancedSwitchableComponentInteractions)this.advanced()).waitUntilContentSwitched(textToContain);
    }

    public abstract class AdvancedSwitchableComponentInteractions {
        private final SwitchType DEFAULT_SWITCH_TYPE = SwitchType.AJAX;
        private SwitchType switchType = SwitchType.AJAX;

        private SwitchType getSwitchType() {
            return this.switchType;
        }

        public void setupSwitchType() {
            this.switchType = this.DEFAULT_SWITCH_TYPE;
        }

        public void setupSwitchType(SwitchType newSwitchType) {
            this.switchType = newSwitchType;
        }

        public WebElement getRootElement() {
            return AbstractSwitchableComponent.this.root;
        }

        protected abstract Predicate<WebDriver> getConditionForContentSwitched(String var1);

        protected void waitUntilContentSwitched(String textToContain) {
            (this.switchType.equals((Object)SwitchType.CLIENT) ? Graphene.waitGui() : (this.switchType.equals((Object)SwitchType.AJAX) ? Graphene.waitAjax() : Graphene.waitModel())).withMessage("Waiting for content to be switched").until(this.getConditionForContentSwitched(textToContain));
        }
    }
}

