/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.tree;

import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.tree.RichFacesTree;
import org.richfaces.fragment.tree.Tree;

public class RichFacesTreeNode
extends RichFacesTree
implements Tree.TreeNode {
    @FindBy(className="rf-trn")
    private WebElement infoElement;
    @FindBy(css=".rf-trn > .rf-trn-hnd")
    private WebElement handleElement;
    @FindBy(css=".rf-trn > .rf-trn-hnd-ldn-fct")
    private WebElement handleLoadingElement;
    @FindBy(css=".rf-trn > .rf-trn-cnt")
    private WebElement containerElement;
    @FindByJQuery(value=".rf-trn > .rf-trn-cnt > .rf-trn-ico:visible")
    private WebElement iconElement;
    @FindBy(css=".rf-trn > .rf-trn-cnt > .rf-trn-lbl")
    private WebElement labelElement;
    @Drone
    private WebDriver driver;
    private final AdvancedNodeInteractionsImpl interactions = new AdvancedNodeInteractionsImpl();

    @Override
    public AdvancedNodeInteractionsImpl advanced() {
        return this.interactions;
    }

    protected WebElement getCorrectElementForInteraction() {
        return this.labelElement;
    }

    @Override
    protected int getIndexOfPickedElement(ChoicePicker picker) {
        return super.getIndexOfPickedElement(picker) - 1;
    }

    public class AdvancedNodeInteractionsImpl
    extends RichFacesTree.AdvancedTreeInteractionsImpl
    implements Tree.TreeNode.AdvancedTreeNodeInteractions {
        private long _timeoutForNodeToBeCollapsed;
        private long _timeoutForNodeToBeExpanded;
        private long _timeoutForNodeToBeSelected;

        public AdvancedNodeInteractionsImpl() {
            super(RichFacesTreeNode.this);
            this._timeoutForNodeToBeCollapsed = -1L;
            this._timeoutForNodeToBeExpanded = -1L;
            this._timeoutForNodeToBeSelected = -1L;
        }

        @Override
        public Tree.TreeNode collapse() {
            if (!this.isCollapsed()) {
                if (this.isToggleByHandle()) {
                    this.getHandleElement().click();
                } else {
                    new Actions(RichFacesTreeNode.this.driver).triggerEventByWD(this.getToggleNodeEvent(), RichFacesTreeNode.this.getCorrectElementForInteraction()).perform();
                }
            }
            this.waitUntilNodeIsCollapsed().perform();
            return RichFacesTreeNode.this;
        }

        @Override
        public Tree.TreeNode expand() {
            if (!this.isExpanded()) {
                if (this.isToggleByHandle()) {
                    this.getHandleElement().click();
                } else {
                    new Actions(RichFacesTreeNode.this.driver).triggerEventByWD(this.getToggleNodeEvent(), RichFacesTreeNode.this.getCorrectElementForInteraction()).perform();
                }
            }
            this.waitUntilNodeIsExpanded().perform();
            return RichFacesTreeNode.this;
        }

        @Override
        public WebElement getContainerElement() {
            return RichFacesTreeNode.this.containerElement;
        }

        @Override
        public WebElement getHandleElement() {
            return RichFacesTreeNode.this.handleElement;
        }

        @Override
        public WebElement getHandleLoadingElement() {
            return RichFacesTreeNode.this.handleLoadingElement;
        }

        @Override
        public WebElement getIconElement() {
            return RichFacesTreeNode.this.iconElement;
        }

        @Override
        public WebElement getLabelElement() {
            return RichFacesTreeNode.this.labelElement;
        }

        @Override
        public WebElement getNodeInfoElement() {
            return RichFacesTreeNode.this.infoElement;
        }

        @Override
        public boolean isCollapsed() {
            return this.getRootElement().getAttribute("class").contains("rf-tr-nd-colps") && this.getHandleElement().getAttribute("class").contains("rf-trn-hnd-colps") && this.getIconElement().getAttribute("class").contains("rf-trn-ico-colps");
        }

        @Override
        public boolean isExpanded() {
            return this.getRootElement().getAttribute("class").contains("rf-tr-nd-exp") && this.getHandleElement().getAttribute("class").contains("rf-trn-hnd-exp") && this.getIconElement().getAttribute("class").contains("rf-trn-ico-exp");
        }

        @Override
        public boolean isLeaf() {
            return this.getRootElement().getAttribute("class").contains("rf-tr-nd-lf") && this.getHandleElement().getAttribute("class").contains("rf-trn-hnd-lf") && this.getIconElement().getAttribute("class").contains("rf-trn-ico-lf");
        }

        @Override
        public boolean isSelected() {
            return this.getContainerElement().getAttribute("class").contains("rf-trn-sel");
        }

        @Override
        public Tree.TreeNode select() {
            if (!this.isSelected()) {
                RichFacesTreeNode.this.getCorrectElementForInteraction().click();
            }
            this.waitUntilNodeIsSelected().perform();
            return RichFacesTreeNode.this;
        }

        public void setuptimeoutForNodeToBeExpanded(long timeoutInMilliseconds) {
            this._timeoutForNodeToBeExpanded = timeoutInMilliseconds;
        }

        public long getTimeoutForNodeToBeExpanded() {
            return this._timeoutForNodeToBeExpanded == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesTreeNode.this.driver) : this._timeoutForNodeToBeExpanded;
        }

        public void setupTimeoutForNodeToBeCollapsed(long timeoutInMilliseconds) {
            this._timeoutForNodeToBeCollapsed = timeoutInMilliseconds;
        }

        public long getTimeoutForNodeToBeCollapsed() {
            return this._timeoutForNodeToBeCollapsed == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesTreeNode.this.driver) : this._timeoutForNodeToBeCollapsed;
        }

        public void setupTimeoutForNodeToBeSelected(long timeoutInMilliseconds) {
            this._timeoutForNodeToBeSelected = timeoutInMilliseconds;
        }

        public long getTimeoutForNodeToBeSelected() {
            return this._timeoutForNodeToBeSelected == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesTreeNode.this.driver) : this._timeoutForNodeToBeSelected;
        }

        @Override
        public WaitingWrapper waitUntilNodeIsCollapsed() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedNodeInteractionsImpl.this.isCollapsed();
                        }
                    });
                }
            }.withMessage("Waiting for node to be collapsed").withTimeout(this.getTimeoutForNodeToBeCollapsed(), TimeUnit.MILLISECONDS);
        }

        @Override
        public WaitingWrapper waitUntilNodeIsExpanded() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedNodeInteractionsImpl.this.isExpanded();
                        }
                    });
                }
            }.withMessage("Waiting for node to be expanded").withTimeout(this.getTimeoutForNodeToBeExpanded(), TimeUnit.MILLISECONDS);
        }

        @Override
        public WaitingWrapper waitUntilNodeIsNotSelected() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AdvancedNodeInteractionsImpl.this.isSelected();
                        }
                    });
                }
            }.withMessage("Waiting for node to be not selected");
        }

        @Override
        public WaitingWrapper waitUntilNodeIsSelected() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedNodeInteractionsImpl.this.isSelected();
                        }
                    });
                }
            }.withMessage("Waiting for node to be selected").withTimeout(this.getTimeoutForNodeToBeSelected(), TimeUnit.MILLISECONDS);
        }
    }
}

