/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.calendar.RichFacesAdvancedInlineCalendar;
import org.richfaces.fragment.calendar.TimeEditor;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;

public class FooterControls {
    @Root
    private WebElement root;
    private RichFacesAdvancedInlineCalendar.CalendarEditor calendarEditor;
    @FindByJQuery(value="div.rf-cal-tl-btn:contains('Clean')")
    private GrapheneElement cleanButtonElement;
    @FindBy(css="td.rf-cal-tl-ftr > div[onclick*='showTimeEditor']")
    private GrapheneElement timeEditorOpenerElement;
    @FindBy(css="td.rf-cal-tl-ftr > div[onclick*='showSelectedDate']")
    private GrapheneElement selectedDateElement;
    @FindByJQuery(value="div.rf-cal-tl-btn:contains('Today')")
    private GrapheneElement todayButtonElement;
    @Drone
    private WebDriver browser;

    private void _openTimeEditor() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot open time editor. Ensure that calendar popup and footer controls are displayed.");
        }
        if (!this.timeEditorOpenerElement.isDisplayed()) {
            throw new RuntimeException("Cannot open time editor. Ensure that the date is set before setting time.");
        }
        this.timeEditorOpenerElement.click();
        this.calendarEditor.getTimeEditor().waitUntilIsVisible().perform();
    }

    public void cleanDate() {
        if (!this.isVisible()) {
            throw new RuntimeException("Footer controls are not displayed, cannot interact with  clean button");
        }
        if (!this.cleanButtonElement.isDisplayed()) {
            throw new RuntimeException("Clean button is not displayed.");
        }
        this.cleanButtonElement.click();
        ((IsElementBuilder)Graphene.waitGui().until().element((WebElement)this.cleanButtonElement).is().not()).visible();
    }

    public WebElement getCleanButtonElement() {
        return this.cleanButtonElement;
    }

    public TimeEditor getTimeEditor() {
        return this.calendarEditor.getTimeEditor();
    }

    public WebElement getTimeEditorOpenerElement() {
        return this.timeEditorOpenerElement;
    }

    public WebElement getTodayButtonElement() {
        return this.todayButtonElement;
    }

    public WebElement getSelectedDateElement() {
        return this.selectedDateElement;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.root);
    }

    public TimeEditor openTimeEditor() {
        if (Utils.isVisible(this.calendarEditor.getTimeEditor().getRoot())) {
            return this.calendarEditor.getTimeEditor();
        }
        this._openTimeEditor();
        return this.calendarEditor.getTimeEditor();
    }

    public void setCalendarEditor(RichFacesAdvancedInlineCalendar.CalendarEditor calendarEditor) {
        this.calendarEditor = calendarEditor;
    }

    public void setTodaysDate() {
        this.todayDate();
    }

    public void todayDate() {
        if (!this.isVisible()) {
            throw new RuntimeException("Footer controls are not displayed, cannot interact with today button");
        }
        if (!this.todayButtonElement.isDisplayed()) {
            throw new RuntimeException("Today button is not displayed.");
        }
        this.todayButtonElement.click();
    }

    public WaitingWrapper waitUntilIsNotVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                ((IsElementBuilder)wait.until().element(FooterControls.this.root).is().not()).visible();
            }
        }.withMessage("Footer controls to be not visible.");
    }

    public WaitingWrapper waitUntilIsVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.until().element(FooterControls.this.root).is().visible();
            }
        }.withMessage("Footer controls to be visible.");
    }
}

