/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.calendar.RichFacesAdvancedInlineCalendar;
import org.richfaces.fragment.calendar.YearAndMonthEditor;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;

public class HeaderControls {
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @FindByJQuery(value=".rf-cal-tl:eq(0) > div")
    private GrapheneElement previousYearElement;
    @FindByJQuery(value=".rf-cal-tl:eq(1) > div")
    private GrapheneElement previousMonthElement;
    @FindBy(css=".rf-cal-hdr-month > div")
    private GrapheneElement yearAndMonthEditorOpenerElement;
    @FindByJQuery(value=".rf-cal-tl:eq(2) > div")
    private GrapheneElement nextMonthElement;
    @FindByJQuery(value=".rf-cal-tl:eq(3) > div")
    private GrapheneElement nextYearElement;
    private RichFacesAdvancedInlineCalendar.CalendarEditor calendarEditor;
    private final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"MMMM, yyyy");
    private long _timeoutForPopupToBeNotVisible = -1L;

    private void _openYearAndMonthEditor() {
        if (!this.isVisible() || !this.yearAndMonthEditorOpenerElement.isDisplayed()) {
            throw new RuntimeException("Cannot open date editor. Ensure that calendar popup and header controls are displayed and some date is set.");
        }
        this.yearAndMonthEditorOpenerElement.click();
        this.calendarEditor.getDateEditor().waitUntilIsVisible().perform();
    }

    public WebElement getNextMonthElement() {
        return this.nextMonthElement;
    }

    public WebElement getNextYearElement() {
        return this.nextYearElement;
    }

    public WebElement getPreviousMonthElement() {
        return this.previousMonthElement;
    }

    public WebElement getPreviousYearElement() {
        return this.previousYearElement;
    }

    public DateTime getYearAndMonth() {
        return this.formatter.parseDateTime(this.yearAndMonthEditorOpenerElement.getText());
    }

    public YearAndMonthEditor getYearAndMonthEditor() {
        return this.calendarEditor.getDateEditor();
    }

    public WebElement getYearAndMonthEditorOpenerElement() {
        return this.yearAndMonthEditorOpenerElement;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.root);
    }

    public void nextMonth() {
        if (!this.isVisible() || !this.nextMonthElement.isDisplayed()) {
            throw new RuntimeException("Cannot interact with nextMonth button. Ensure that calendar popup and header controls are displayed.");
        }
        String before = this.yearAndMonthEditorOpenerElement.getText();
        this.nextMonthElement.click();
        ((StringMatcher)Graphene.waitAjax().until().element((WebElement)this.yearAndMonthEditorOpenerElement).text().not()).equalTo(before);
    }

    public void nextYear() {
        if (!this.isVisible() || !this.nextYearElement.isDisplayed()) {
            throw new RuntimeException("Cannot interact with nextYear button. Ensure that calendar popup and header controls are displayed.");
        }
        String before = this.yearAndMonthEditorOpenerElement.getText();
        this.nextYearElement.click();
        ((StringMatcher)Graphene.waitAjax().until().element((WebElement)this.yearAndMonthEditorOpenerElement).text().not()).equalTo(before);
    }

    public YearAndMonthEditor openYearAndMonthEditor() {
        if (Utils.isVisible(this.calendarEditor.getDateEditor().getRoot())) {
            return this.calendarEditor.getDateEditor();
        }
        this._openYearAndMonthEditor();
        return this.calendarEditor.getDateEditor();
    }

    public void previousYear() {
        if (!this.isVisible() || !this.previousYearElement.isDisplayed()) {
            throw new RuntimeException("Cannot interact with previousYear button. Ensure that calendar popup and header controls are displayed.");
        }
        String before = this.yearAndMonthEditorOpenerElement.getText();
        this.previousYearElement.click();
        ((StringMatcher)Graphene.waitAjax().until().element((WebElement)this.yearAndMonthEditorOpenerElement).text().not()).equalTo(before);
    }

    public void previousMonth() {
        if (!this.isVisible() || !this.previousMonthElement.isDisplayed()) {
            throw new RuntimeException("Cannot interact with previousMonth button. Ensure that calendar popup and header controls are displayed.");
        }
        String before = this.yearAndMonthEditorOpenerElement.getText();
        this.previousMonthElement.click();
        ((StringMatcher)Graphene.waitAjax().until().element((WebElement)this.yearAndMonthEditorOpenerElement).text().not()).equalTo(before);
    }

    public void setCalendarEditor(RichFacesAdvancedInlineCalendar.CalendarEditor calendarEditor) {
        this.calendarEditor = calendarEditor;
    }

    public void setupTimeoutForPopupToBeNotVisible(long timeoutInMilliseconds) {
        this._timeoutForPopupToBeNotVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForPopupToBeNotVisible() {
        return this._timeoutForPopupToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutForPopupToBeNotVisible;
    }

    public WaitingWrapper waitUntilIsNotVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                ((IsElementBuilder)wait.until().element(HeaderControls.this.root).is().not()).visible();
            }
        }.withMessage("Header controls to be not visible.").withTimeout(this.getTimeoutForPopupToBeNotVisible(), TimeUnit.MILLISECONDS);
    }

    public WaitingWrapper waitUntilIsVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.until().element(HeaderControls.this.root).is().visible();
            }
        }.withMessage("Header controls to be visible.");
    }
}

