/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.dataTable;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.TypeResolver;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.dataTable.DataTable;

public abstract class AbstractTable<HEADER, ROW, FOOTER>
implements DataTable<HEADER, ROW, FOOTER>,
AdvancedInteractions<AdvancedTableInteractions> {
    @Root
    protected WebElement root;
    @Drone
    protected WebDriver browser;
    private final Class<HEADER> headerClass = TypeResolver.resolveRawArguments(DataTable.class, this.getClass())[0];
    private final Class<ROW> rowClass = TypeResolver.resolveRawArguments(DataTable.class, this.getClass())[1];
    private final Class<FOOTER> footerClass = TypeResolver.resolveRawArguments(DataTable.class, this.getClass())[2];

    @Override
    public ROW getRow(int n) {
        if (this.advanced().getNumberOfVisibleRows() - 1 < n) {
            throw new IllegalArgumentException("There is not so many rows! Requesting: " + n + "but there is only: " + this.advanced().getNumberOfVisibleRows());
        }
        return (ROW)Graphene.createPageFragment(this.rowClass, (WebElement)this.advanced().getTableRowsElements().get(n));
    }

    @Override
    public ROW getFirstRow() {
        return this.getRow(0);
    }

    @Override
    public ROW getLastRow() {
        return this.getRow(this.advanced().getNumberOfVisibleRows() - 1);
    }

    @Override
    public List<ROW> getAllRows() {
        ArrayList<ROW> result = new ArrayList<ROW>();
        for (int i = 0; i < this.advanced().getNumberOfVisibleRows(); ++i) {
            result.add(this.getRow(i));
        }
        return result;
    }

    @Override
    public HEADER getHeader() {
        return (HEADER)Graphene.createPageFragment(this.headerClass, (WebElement)this.advanced().getWholeTableHeaderElement());
    }

    @Override
    public FOOTER getFooter() {
        return (FOOTER)Graphene.createPageFragment(this.footerClass, (WebElement)this.advanced().getWholeTableFooterElement());
    }

    @Override
    public abstract AdvancedTableInteractions advanced();

    public abstract class AdvancedTableInteractions {
        public int getNumberOfColumns() {
            if (!this.isVisible()) {
                return 0;
            }
            return this.getFirstRowCellsElements().size();
        }

        public int getNumberOfVisibleRows() {
            if (!this.isVisible()) {
                return 0;
            }
            return this.getTableRowsElements().size();
        }

        public boolean isVisible() {
            return Utils.isVisible(AbstractTable.this.root);
        }

        public boolean isNoData() {
            return Utils.isVisible(this.getNoDataElement());
        }

        public WebElement getCellElement(int column, int row) {
            return this.getTableRowsElements().get(row).findElement(this.getSelectorForCell(column));
        }

        public WebElement getColumnHeaderElement(int column) {
            return this.getColumnHeaderElements().get(column);
        }

        public WebElement getColumnFooterElement(int column) {
            return this.getColumnFooterElements().get(column);
        }

        public abstract WebElement getNoDataElement();

        public abstract List<WebElement> getTableRowsElements();

        public abstract List<WebElement> getFirstRowCellsElements();

        public abstract By getSelectorForCell(int var1);

        public abstract WebElement getWholeTableHeaderElement();

        public abstract WebElement getWholeTableFooterElement();

        public abstract WebElement getHeaderElement();

        public abstract WebElement getFooterElement();

        public abstract List<WebElement> getColumnHeaderElements();

        public abstract List<WebElement> getColumnFooterElements();
    }
}

