/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.editor;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.ClearType;
import org.richfaces.fragment.editor.Editor;
import org.richfaces.fragment.editor.toolbar.RichFacesEditorToolbar;

public class RichFacesEditor
implements Editor,
AdvancedInteractions<AdvancedEditorInteractions> {
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @FindBy(css=".cke_toolbox")
    private RichFacesEditorToolbar toolbar;
    @ArquillianResource
    private JavascriptExecutor executor;
    private final AdvancedEditorInteractions advancedInteractions = new AdvancedEditorInteractions();

    @Override
    public AdvancedEditorInteractions advanced() {
        return this.advancedInteractions;
    }

    @Override
    public void clear() {
        this.advanced().clear(ClearType.JS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText() {
        try {
            String string = this.switchToEditorActiveArea().getText();
            return string;
        }
        finally {
            this.browser.switchTo().defaultContent();
        }
    }

    private WebElement switchToEditorActiveArea() {
        this.browser.switchTo().frame(0);
        WebElement activeArea = this.browser.findElement(By.tagName((String)"body"));
        activeArea.click();
        return activeArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void type(String text) {
        try {
            this.switchToEditorActiveArea().sendKeys(new CharSequence[]{""});
            ((JavascriptExecutor)this.browser).executeScript("document.body.textContent= document.body.textContent + '" + text + "'", new Object[0]);
        }
        finally {
            this.browser.switchTo().defaultContent();
        }
    }

    public class AdvancedEditorInteractions {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void clear(ClearType clearType) {
            try {
                WebElement activeArea = RichFacesEditor.this.switchToEditorActiveArea();
                switch (clearType) {
                    case BACKSPACE: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    case DELETE: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    case ESCAPE_SQ: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    case JS: {
                        RichFacesEditor.this.executor.executeScript("arguments[0].innerHTML = '';", new Object[]{activeArea});
                        return;
                    }
                    case WD: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown type of clear method " + (Object)((Object)clearType));
                    }
                }
            }
            finally {
                RichFacesEditor.this.browser.switchTo().defaultContent();
            }
        }

        public RichFacesEditorToolbar getToolbar() {
            return RichFacesEditor.this.toolbar;
        }
    }
}

