/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.fileUpload;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.fileUpload.FileUpload;
import org.richfaces.fragment.fileUpload.FileUploadItem;
import org.richfaces.fragment.list.AbstractListComponent;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.list.RichFacesListItem;

public class RichFacesFileUpload
implements FileUpload,
AdvancedInteractions<AdvancedFileUploadInteractions> {
    @Root
    private WebElement rootElement;
    @ArquillianResource
    private JavascriptExecutor executor;
    @FindBy(className="rf-fu-lst")
    private RichFacesFileUploadList items;
    @FindBy(className="rf-fu-btn-cnt-add")
    private WebElement addButtonElement;
    @FindBy(className="rf-fu-btn-cnt-add-dis")
    private WebElement disabledAddButtonElement;
    @FindBy(className="rf-fu-btn-clr")
    private WebElement clearAllButtonElement;
    @FindBy(className="rf-fu-btn-cnt-upl")
    private WebElement uploadButtonElement;
    @FindByJQuery(value=".rf-fu-inp:last")
    private WebElement fileInputElement;
    @FindBy(className="rf-fu-inp")
    private List<WebElement> fileInputElements;
    @FindBy(css=".rf-fu-btn-add > span")
    private WebElement inputContainer;
    private final AdvancedFileUploadInteractions interactions = new AdvancedFileUploadInteractions();

    @Override
    public boolean addFile(File file) {
        final int expectedSize = this.fileInputElements.size() + 1;
        String containerStyleClassBefore = this.inputContainer.getAttribute("class");
        Utils.jQ("attr('class', '')", this.inputContainer);
        this.fileInputElement.sendKeys(new CharSequence[]{file.getAbsolutePath()});
        Utils.jQ("attr('class', '" + containerStyleClassBefore + "')", this.inputContainer);
        try {
            Graphene.waitGui().withTimeout(1L, TimeUnit.SECONDS).until((Predicate)new Predicate<WebDriver>(){

                public boolean apply(WebDriver input) {
                    return RichFacesFileUpload.this.fileInputElements.size() == expectedSize;
                }
            });
        }
        catch (TimeoutException ignored) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public AdvancedFileUploadInteractions advanced() {
        return this.interactions;
    }

    @Override
    public FileUpload clearAll() {
        this.clearAllButtonElement.click();
        Graphene.waitGui().until((Predicate)new Predicate<WebDriver>(){

            public boolean apply(WebDriver input) {
                return RichFacesFileUpload.this.items.isEmpty();
            }
        });
        return this;
    }

    @Override
    public FileUpload upload() {
        this.uploadButtonElement.click();
        return this;
    }

    public class AdvancedFileUploadInteractions {
        private static final String DEFAULT_DONE_LABEL = "Done";
        private String doneLabel;

        public WebElement getRootElement() {
            return RichFacesFileUpload.this.rootElement;
        }

        public WebElement getAddButtonElement() {
            return RichFacesFileUpload.this.addButtonElement;
        }

        public WebElement getDisabledAddButtonElement() {
            return RichFacesFileUpload.this.disabledAddButtonElement;
        }

        public WebElement getClearAllButtonElement() {
            return RichFacesFileUpload.this.clearAllButtonElement;
        }

        public WebElement getFileInputElement() {
            return RichFacesFileUpload.this.fileInputElement;
        }

        public WebElement getUploadButtonElement() {
            return RichFacesFileUpload.this.uploadButtonElement;
        }

        public String getDoneLabel() {
            return (String)Optional.fromNullable((Object)this.doneLabel).or((Object)DEFAULT_DONE_LABEL);
        }

        public ListComponent<? extends FileUploadItem> getItems() {
            return RichFacesFileUpload.this.items;
        }

        public void removeFile(int index) {
            this.removeFile(ChoicePickerHelper.byIndex().index(index));
        }

        public void removeFile(String match) {
            this.removeFile(ChoicePickerHelper.byVisibleText().match(match));
        }

        public void removeFile(ChoicePicker picker) {
            this.getItems().getItem(picker).remove();
        }

        public void setupDoneLabel() {
            this.doneLabel = DEFAULT_DONE_LABEL;
        }

        public void setupDoneLabel(String doneLabel) {
            this.doneLabel = doneLabel;
        }
    }

    public static class RichFacesFileUploadList
    extends AbstractListComponent<FileUploadItemImpl> {
    }

    public class FileUploadItemImpl
    extends RichFacesListItem
    implements FileUploadItem {
        @FindBy(className="rf-fu-itm-lbl")
        private WebElement filenameElement;
        @FindBy(className="rf-fu-itm-st")
        private WebElement stateElement;
        @FindBy(className="rf-fu-itm-lnk")
        private WebElement clearOrDeleteElement;

        @Override
        public WebElement getClearOrDeleteElement() {
            return this.clearOrDeleteElement;
        }

        @Override
        public String getFilename() {
            return this.filenameElement.getText();
        }

        @Override
        public WebElement getFilenameElement() {
            return this.filenameElement;
        }

        @Override
        public String getState() {
            return this.stateElement.getText();
        }

        @Override
        public WebElement getStateElement() {
            return this.stateElement;
        }

        @Override
        public boolean isUploaded() {
            if (Utils.isVisible(this.stateElement) && this.getState().equals(RichFacesFileUpload.this.advanced().getDoneLabel())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public void remove() {
            this.clearOrDeleteElement.click();
        }
    }
}

