/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.notify;

import com.google.common.base.Predicate;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.list.AbstractListComponent;
import org.richfaces.fragment.list.ListItem;
import org.richfaces.fragment.message.Message;
import org.richfaces.fragment.messages.Messages;
import org.richfaces.fragment.notify.Notify;
import org.richfaces.fragment.notify.NotifyMessage;
import org.richfaces.fragment.notify.RichFacesNotifyMessage;

public class RichFacesNotify
extends AbstractListComponent<NotifyMessageItemImpl>
implements Notify<NotifyMessageItemImpl> {
    @Drone
    private WebDriver driver;
    private String styleClass = "";
    private static final String NOTIFY_MSG_STYLECLASS = "rf-ntf";
    private static final String NOTIFY_FATAL_MSG_STYLECLASS = "rf-ntf-ftl";
    private static final String NOTIFY_ERROR_MSG_STYLECLASS = "rf-ntf-err";
    private static final String NOTIFY_WARN_MSG_STYLECLASS = "rf-ntf-wrn";
    private static final String NOTIFY_INFO_MSG_STYLECLASS = "rf-ntf-inf";
    private final AdvancedNotifyInteractionsImpl interactions = new AdvancedNotifyInteractionsImpl();

    @Override
    public AdvancedNotifyInteractionsImpl advanced() {
        return this.interactions;
    }

    private By getByForNotifyWithStyleClass(String additionalStyleClass) {
        return By.cssSelector((String)("div" + this.getSelectorForStyleClassOrEmpty(NOTIFY_MSG_STYLECLASS) + this.getSelectorForStyleClassOrEmpty(this.styleClass) + this.getSelectorForStyleClassOrEmpty(additionalStyleClass)));
    }

    private String getSelectorForStyleClassOrEmpty(String styleClass) {
        return styleClass == null || styleClass.isEmpty() ? "" : "." + styleClass;
    }

    private List<NotifyMessageItemImpl> getErrorMessages() {
        return this.instantiateFragments(NotifyMessageItemImpl.class, this.driver.findElements(this.getByForNotifyWithStyleClass(NOTIFY_ERROR_MSG_STYLECLASS)));
    }

    private List<NotifyMessageItemImpl> getFatalMessages() {
        return this.instantiateFragments(NotifyMessageItemImpl.class, this.driver.findElements(this.getByForNotifyWithStyleClass(NOTIFY_FATAL_MSG_STYLECLASS)));
    }

    private List<NotifyMessageItemImpl> getInfoMessages() {
        return this.instantiateFragments(NotifyMessageItemImpl.class, this.driver.findElements(this.getByForNotifyWithStyleClass(NOTIFY_INFO_MSG_STYLECLASS)));
    }

    @Override
    public List<? extends NotifyMessage> getItems(Message.MessageType type) {
        switch (type) {
            case OK: {
                throw new UnsupportedOperationException("Notify messages does not support messages of type 'OK'.");
            }
            case INFORMATION: {
                return this.getInfoMessages();
            }
            case WARNING: {
                return this.getWarnMessages();
            }
            case ERROR: {
                return this.getErrorMessages();
            }
            case FATAL: {
                return this.getFatalMessages();
            }
        }
        throw new UnsupportedOperationException("Unknown type " + (Object)((Object)type));
    }

    @Override
    protected List<WebElement> getItemsElements() {
        return this.driver.findElements(this.getByForNotifyWithStyleClass(null));
    }

    private List<NotifyMessageItemImpl> getWarnMessages() {
        return this.instantiateFragments(NotifyMessageItemImpl.class, this.driver.findElements(this.getByForNotifyWithStyleClass(NOTIFY_WARN_MSG_STYLECLASS)));
    }

    public static class NotifyMessageItemImpl
    extends RichFacesNotifyMessage
    implements NotifyMessage,
    ListItem {
        @Override
        public GrapheneElement getRootElement() {
            return super.getRootElement();
        }

        @Override
        public String getText() {
            return this.getRootElement().getText();
        }
    }

    public class AdvancedNotifyInteractionsImpl
    implements Messages.AdvancedMessagesInteractions {
        public void setStyleClassToContain(String styleClass) {
            RichFacesNotify.this.styleClass = styleClass;
        }

        @Override
        public boolean isVisible() {
            return !RichFacesNotify.this.getItemsElements().isEmpty();
        }

        @Override
        public WaitingWrapper waitUntilMessagesAreNotVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AdvancedNotifyInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for notify to be not visible.");
        }

        @Override
        public WaitingWrapper waitUntilMessagesAreVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedNotifyInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for notify to be visible.");
        }
    }
}

