/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Event;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.tree.RichFacesTreeNode;
import org.richfaces.fragment.tree.Tree;

public class RichFacesTree
implements Tree,
AdvancedInteractions<AdvancedTreeInteractionsImpl> {
    @Root
    private WebElement root;
    @FindByJQuery(value="> .rf-tr-nd")
    private List<RichFacesTreeNode> childNodes;
    @FindByJQuery(value="> .rf-tr-nd")
    private List<WebElement> childNodesElements;
    private final AdvancedTreeInteractionsImpl interactions = new AdvancedTreeInteractionsImpl();

    @Override
    public AdvancedTreeInteractionsImpl advanced() {
        return this.interactions;
    }

    @Override
    public Tree.TreeNode collapseNode(int index) {
        return this.collapseNode(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public Tree.TreeNode collapseNode(ChoicePicker picker) {
        return this.getChildNodes().get(this.getIndexOfPickedElement(picker)).advanced().collapse();
    }

    @Override
    public Tree.TreeNode expandNode(int index) {
        return this.expandNode(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public Tree.TreeNode expandNode(ChoicePicker picker) {
        return this.getChildNodes().get(this.getIndexOfPickedElement(picker)).advanced().expand();
    }

    protected List<? extends Tree.TreeNode> getChildNodes() {
        return Collections.unmodifiableList(this.childNodes);
    }

    protected List<WebElement> getChildNodesElements() {
        return Collections.unmodifiableList(this.childNodesElements);
    }

    protected int getIndexOfPickedElement(ChoicePicker picker) {
        if (this.getChildNodesElements().isEmpty()) {
            throw new RuntimeException("Cannot find child node, because there are no child nodes.");
        }
        return Utils.getIndexOfElement(picker.pick(this.getChildNodesElements()));
    }

    @Override
    public Tree.TreeNode selectNode(int index) {
        return this.selectNode(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public Tree.TreeNode selectNode(ChoicePicker picker) {
        return this.getChildNodes().get(this.getIndexOfPickedElement(picker)).advanced().select();
    }

    public class AdvancedTreeInteractionsImpl
    implements Tree.AdvancedTreeInteractions {
        private final Event DEFAULT_TOGGLE_NODE_EVENT = Event.CLICK;
        private final boolean DEFAULT_TOGGLE_BY_HANDLE;
        private boolean toggleByHandle = this.DEFAULT_TOGGLE_BY_HANDLE = Boolean.TRUE.booleanValue();
        private Event toggleNodeEvent = this.DEFAULT_TOGGLE_NODE_EVENT;

        @Override
        public Tree.TreeNode getFirstNode() {
            return this.getNodes().get(0);
        }

        @Override
        public List<? extends Tree.TreeNode> getLeafNodes() {
            ArrayList result = Lists.newArrayList();
            for (Tree.TreeNode treeNode : RichFacesTree.this.getChildNodes()) {
                if (!treeNode.advanced().isLeaf()) continue;
                result.add(treeNode);
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public List<? extends Tree.TreeNode> getNodes() {
            return RichFacesTree.this.getChildNodes();
        }

        @Override
        public List<? extends Tree.TreeNode> getNodesCollapsed() {
            ArrayList result = Lists.newArrayList();
            for (Tree.TreeNode treeNode : RichFacesTree.this.getChildNodes()) {
                if (!treeNode.advanced().isCollapsed()) continue;
                result.add(treeNode);
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public List<WebElement> getNodesElements() {
            return RichFacesTree.this.getChildNodesElements();
        }

        @Override
        public List<? extends Tree.TreeNode> getNodesExpanded() {
            ArrayList result = Lists.newArrayList();
            for (Tree.TreeNode treeNode : RichFacesTree.this.getChildNodes()) {
                if (!treeNode.advanced().isExpanded()) continue;
                result.add(treeNode);
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public WebElement getRootElement() {
            return RichFacesTree.this.root;
        }

        @Override
        public List<? extends Tree.TreeNode> getSelectedNodes() {
            ArrayList result = Lists.newArrayList();
            for (Tree.TreeNode treeNode : RichFacesTree.this.getChildNodes()) {
                if (!treeNode.advanced().isSelected()) continue;
                result.add(treeNode);
            }
            return Collections.unmodifiableList(result);
        }

        protected Event getToggleNodeEvent() {
            return this.toggleNodeEvent;
        }

        protected boolean isToggleByHandle() {
            return this.toggleByHandle;
        }

        @Override
        public void setupToggleByHandle() {
            this.toggleByHandle = this.DEFAULT_TOGGLE_BY_HANDLE;
        }

        @Override
        public void setupToggleByHandle(boolean toggleByHandle) {
            this.toggleByHandle = toggleByHandle;
        }

        @Override
        public void setupToggleNodeEvent() {
            this.toggleNodeEvent = this.DEFAULT_TOGGLE_NODE_EVENT;
        }

        @Override
        public void setupToggleNodeEvent(Event toggleNodeEvent) {
            this.toggleNodeEvent = toggleNodeEvent;
        }
    }
}

