/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.message;

import com.google.common.base.Predicate;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.WebDriver;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.message.Message;

public abstract class AbstractMessage
implements Message,
AdvancedInteractions<Message.AdvancedMessageInteractions> {
    @Root
    private GrapheneElement root;

    protected abstract String getCssClass(Message.MessageType var1);

    @Override
    public String getDetail() {
        return ((Message.AdvancedMessageInteractions)this.advanced()).getDetailElement().getText();
    }

    @Override
    public String getSummary() {
        return ((Message.AdvancedMessageInteractions)this.advanced()).getSummaryElement().getText();
    }

    @Override
    public Message.MessageType getType() {
        String attribute = ((Message.AdvancedMessageInteractions)this.advanced()).getRootElement().getAttribute("class");
        for (Message.MessageType type : Message.MessageType.values()) {
            if (!attribute.contains(this.getCssClass(type))) continue;
            return type;
        }
        return null;
    }

    public abstract class AdvancedMessageInteractionsImpl
    implements Message.AdvancedMessageInteractions {
        public GrapheneElement getRootElement() {
            return AbstractMessage.this.root;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getSummaryElement()) || Utils.isVisible(this.getDetailElement());
        }

        @Override
        public WaitingWrapper waitUntilMessageIsNotVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AdvancedMessageInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for message to be not visible.");
        }

        @Override
        public WaitingWrapper waitUntilMessageIsVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedMessageInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for message to be visible.");
        }
    }
}

