/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.orderingList;

import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.common.picker.MultipleChoicePicker;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.orderingList.OrderingInteraction;
import org.richfaces.fragment.orderingList.OrderingList;
import org.richfaces.fragment.orderingList.PuttingSelectedItem;
import org.richfaces.fragment.orderingList.SelectableListItem;

public abstract class AbstractOrderingList
implements OrderingList,
AdvancedVisibleComponentIteractions<AdvancedOrderingListInteractions> {
    @Root
    private WebElement root;
    @Drone
    private WebDriver driver;
    private final OrderingInteraction orderingInteraction = new OrderingInteractionImpl();
    private final PuttingSelectedItem puttingSelectedItem = new PuttingSelectedItemImpl();

    @Override
    public abstract AdvancedOrderingListInteractions advanced();

    @Override
    public PuttingSelectedItem select(String visibleText) {
        return this.select(ChoicePickerHelper.byVisibleText().match(visibleText));
    }

    @Override
    public PuttingSelectedItem select(Integer index) {
        return this.select(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PuttingSelectedItem select(ChoicePicker picker) {
        this.unselectAll();
        this.selectItem(picker.pick(this.advanced().getItemsElements()));
        return this.getPuttingSelectedItem();
    }

    protected void selectItem(final WebElement item) {
        new Actions(this.driver).keyDown(Keys.CONTROL).click(item).keyUp(Keys.CONTROL).addAction(new Action(){

            public void perform() {
                Graphene.waitGui().until().element(item).attribute("class").contains(AbstractOrderingList.this.advanced().getStyleForSelectedItem());
            }
        }).perform();
    }

    protected void selectItems(List<WebElement> list) {
        for (WebElement webElement : list) {
            this.selectItem(webElement);
        }
    }

    protected void unselectAll() {
        if (!this.advanced().getSelectedItemsElements().isEmpty()) {
            new Actions(this.driver).click(this.advanced().getItemsElements().get(0)).keyDown(Keys.CONTROL).click(this.advanced().getItemsElements().get(0)).keyUp(Keys.CONTROL).addAction(new Action(){

                public void perform() {
                    ((StringMatcher)Graphene.waitGui().until().element(AbstractOrderingList.this.advanced().getItemsElements().get(0)).attribute("class").not()).contains("rf-ord-sel");
                }
            }).perform();
            if (!this.advanced().getSelectedItemsElements().isEmpty()) {
                throw new RuntimeException("The unselection was not successfull.");
            }
        }
    }

    protected OrderingInteraction getOrderingInteraction() {
        return this.orderingInteraction;
    }

    protected PuttingSelectedItem getPuttingSelectedItem() {
        return this.puttingSelectedItem;
    }

    public abstract class AdvancedOrderingListInteractions
    implements VisibleComponentInteractions {
        public abstract WebElement getBottomButtonElement();

        public abstract WebElement getCaptionElement();

        public abstract WebElement getDownButtonElement();

        public abstract WebElement getHeaderElement();

        public abstract List<WebElement> getItemsElements();

        public abstract ListComponent<? extends SelectableListItem> getList();

        public abstract WebElement getContentAreaElement();

        public WebElement getRootElement() {
            return AbstractOrderingList.this.root;
        }

        public abstract List<WebElement> getSelectedItemsElements();

        protected abstract String getStyleForSelectedItem();

        public abstract WebElement getTopButtonElement();

        public abstract WebElement getUpButtonElement();

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }

        public OrderingInteraction select(String visibleText, String ... otherTexts) {
            ChoicePickerHelper.ByVisibleTextChoicePicker picker = ChoicePickerHelper.byVisibleText().allRulesMustPass(false).match(visibleText);
            for (String string : otherTexts) {
                picker.match(string);
            }
            return this.select(picker);
        }

        public OrderingInteraction select(Integer index, Integer ... otherIndexes) {
            ChoicePickerHelper.ByIndexChoicePicker picker = ChoicePickerHelper.byIndex().index(index);
            for (Integer integer : otherIndexes) {
                picker.index(integer);
            }
            return this.select(picker);
        }

        public OrderingInteraction select(MultipleChoicePicker picker) {
            AbstractOrderingList.this.unselectAll();
            AbstractOrderingList.this.selectItems(picker.pickMultiple(AbstractOrderingList.this.advanced().getItemsElements()));
            return AbstractOrderingList.this.getOrderingInteraction();
        }
    }

    private class OrderingInteractionImpl
    implements OrderingInteraction {
        private OrderingInteractionImpl() {
        }

        private void checkIfActionPosibleAndPerform(WebElement button, int times) {
            if (!button.isEnabled()) {
                throw new RuntimeException("No items are selected or button is disabled.");
            }
            for (int i = 0; i < times; ++i) {
                button.click();
            }
        }

        @Override
        public void bottom() {
            this.checkIfActionPosibleAndPerform(AbstractOrderingList.this.advanced().getBottomButtonElement(), 1);
        }

        @Override
        public void down(int times) {
            this.checkIfActionPosibleAndPerform(AbstractOrderingList.this.advanced().getDownButtonElement(), times);
        }

        @Override
        public void top() {
            this.checkIfActionPosibleAndPerform(AbstractOrderingList.this.advanced().getTopButtonElement(), 1);
        }

        @Override
        public void up(int times) {
            this.checkIfActionPosibleAndPerform(AbstractOrderingList.this.advanced().getUpButtonElement(), times);
        }
    }

    private class PuttingSelectedItemImpl
    implements PuttingSelectedItem {
        private PuttingSelectedItemImpl() {
        }

        private OrderingList putAction(int positionSource, int positionTarget, int differenceToEnd) {
            if (positionSource != positionTarget) {
                int differenceBetween = positionTarget - positionSource;
                int absBetween = Math.abs(differenceBetween);
                int min = Math.min(absBetween, Math.min(positionTarget, differenceToEnd));
                if (min == absBetween) {
                    this.singleStepMove(differenceBetween);
                } else if (min == positionTarget) {
                    AbstractOrderingList.this.getOrderingInteraction().top();
                    if (positionTarget != 0) {
                        this.singleStepMove(positionTarget);
                    }
                } else {
                    AbstractOrderingList.this.getOrderingInteraction().bottom();
                    if (differenceToEnd != 0) {
                        this.singleStepMove(-differenceToEnd);
                    }
                }
            }
            return AbstractOrderingList.this;
        }

        @Override
        public OrderingList putItAfter(ChoicePicker picker) {
            int indexOfTargetItem = Utils.getIndexOfElement(picker.pick(AbstractOrderingList.this.advanced().getItemsElements())) + 1;
            return this.putAction(Utils.getIndexOfElement(AbstractOrderingList.this.advanced().getSelectedItemsElements().get(0)), indexOfTargetItem, AbstractOrderingList.this.advanced().getItemsElements().size() - indexOfTargetItem);
        }

        @Override
        public OrderingList putItAfter(int index) {
            return this.putItAfter(ChoicePickerHelper.byIndex().index(index));
        }

        @Override
        public OrderingList putItAfter(String match) {
            return this.putItAfter(ChoicePickerHelper.byVisibleText().match(match));
        }

        @Override
        public OrderingList putItBefore(ChoicePicker picker) {
            int indexOfTargetItem = Utils.getIndexOfElement(picker.pick(AbstractOrderingList.this.advanced().getItemsElements()));
            return this.putAction(Utils.getIndexOfElement(AbstractOrderingList.this.advanced().getSelectedItemsElements().get(0)), indexOfTargetItem, AbstractOrderingList.this.advanced().getItemsElements().size() - indexOfTargetItem);
        }

        @Override
        public OrderingList putItBefore(int index) {
            return this.putItBefore(ChoicePickerHelper.byIndex().index(index));
        }

        @Override
        public OrderingList putItBefore(String match) {
            return this.putItBefore(ChoicePickerHelper.byVisibleText().match(match));
        }

        private void singleStepMove(int difference) {
            if (difference != 0) {
                if (difference > 0) {
                    AbstractOrderingList.this.getOrderingInteraction().down(Math.abs(difference));
                } else {
                    AbstractOrderingList.this.getOrderingInteraction().up(Math.abs(difference));
                }
            }
        }
    }
}

