/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.inplaceInput;

import org.jboss.arquillian.graphene.condition.element.WebElementConditionFactory;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.inplaceInput.ConfirmOrCancel;

public abstract class AbstractConfirmOrCancel
implements ConfirmOrCancel {
    @Override
    public void confirm() {
        new Actions(this.getBrowser()).sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, Keys.RETURN})}).perform();
        this.waitAfterConfirmOrCancel();
    }

    @Override
    public void confirmByControlls() {
        this.checkControllsAreAvailable();
        Utils.triggerJQ("mousedown", this.getConfirmButton());
        this.waitAfterConfirmOrCancel();
    }

    @Override
    public void cancel() {
        this.getInput().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, Keys.ESCAPE})});
        this.waitAfterConfirmOrCancel();
    }

    @Override
    public void cancelByControlls() {
        this.checkControllsAreAvailable();
        Utils.triggerJQ("mousedown", this.getCancelButton());
        this.waitAfterConfirmOrCancel();
    }

    private void checkControllsAreAvailable() {
        boolean condition = (Boolean)new WebElementConditionFactory(this.getConfirmButton()).isPresent().apply((Object)this.getBrowser());
        if (!condition) {
            throw new IllegalStateException("You are trying to use cotrolls to confirm/cancel the input, however, there are no controlls!");
        }
    }

    public abstract WebDriver getBrowser();

    public abstract WebElement getConfirmButton();

    public abstract WebElement getInput();

    public abstract WebElement getCancelButton();

    public abstract void waitAfterConfirmOrCancel();
}

