/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.inputNumberSlider;

import com.google.common.base.Preconditions;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.inputNumberSlider.AbstractNumberInput;
import org.richfaces.fragment.inputNumberSlider.InputNumberSlider;

public class RichFacesInputNumberSlider
extends AbstractNumberInput
implements InputNumberSlider,
AdvancedVisibleComponentIteractions<AdvancedInputNumberSliderInteractions> {
    @FindBy(className="rf-insl-inc")
    private WebElement arrowIncrease;
    @FindBy(className="rf-insl-dec")
    private WebElement arrowDecrease;
    @FindBy(css="span.rf-insl-inp-cntr > input.rf-insl-inp")
    private TextInputComponentImpl input;
    @FindBy(className="rf-insl-hnd-cntr")
    private WebElement handleContainer;
    @FindBy(className="rf-insl-hnd")
    private WebElement handle;
    @FindBy(className="rf-insl-hnd-dis")
    private WebElement disabledHandle;
    @FindBy(className="rf-insl-mn")
    private WebElement min;
    @FindBy(className="rf-insl-mx")
    private WebElement max;
    @FindBy(css="span.rf-insl-trc")
    private WebElement trackComponent;
    @FindBy(className="rf-insl-tt")
    private WebElement tooltip;
    @FindBy(css="span.rf-insl-trc")
    private WebElement sliderElement;
    @Drone
    private WebDriver browser;
    @Root
    private WebElement root;
    private final AdvancedInputNumberSliderInteractions advancedInteractons = new AdvancedInputNumberSliderInteractions();

    @Override
    public AdvancedInputNumberSliderInteractions advanced() {
        return this.advancedInteractons;
    }

    @Override
    public void slideToValue(double n) {
        this.advanced().dragHandleToPointInTrace((int)(n * (double)this.advanced().getWidth()));
    }

    protected void scrollToView() {
        new Actions(this.browser).moveToElement(this.advanced().getRootElement()).perform();
    }

    public class AdvancedInputNumberSliderInteractions
    extends AbstractNumberInput.AdvancedNumberInputInteractions
    implements VisibleComponentInteractions {
        public void dragHandleToPointInTrace(int pixelInTrace) {
            Preconditions.checkArgument((pixelInTrace >= 0 && pixelInTrace <= this.getWidth() ? 1 : 0) != 0, (Object)"Cannot slide outside the trace.");
            if (!Utils.isVisible(RichFacesInputNumberSlider.this.advanced().getRootElement())) {
                throw new RuntimeException("Trace is not visible.");
            }
            RichFacesInputNumberSlider.this.scrollToView();
            Actions actions = new Actions(RichFacesInputNumberSlider.this.browser).moveToElement(RichFacesInputNumberSlider.this.advanced().getHandleElement(), 0, 0).clickAndHold();
            actions.moveToElement(RichFacesInputNumberSlider.this.advanced().getRootElement(), pixelInTrace, 0);
            actions.release(RichFacesInputNumberSlider.this.advanced().getHandleElement()).build().perform();
        }

        public int getWidth() {
            return Utils.getLocations(this.getHandleContainer()).getWidth();
        }

        @Override
        public WebElement getArrowIncreaseElement() {
            return RichFacesInputNumberSlider.this.arrowIncrease;
        }

        @Override
        public WebElement getArrowDecreaseElement() {
            return RichFacesInputNumberSlider.this.arrowDecrease;
        }

        @Override
        public TextInputComponentImpl getInput() {
            return RichFacesInputNumberSlider.this.input;
        }

        public WebElement getRootElement() {
            return RichFacesInputNumberSlider.this.root;
        }

        public WebElement getDisabledHandleElement() {
            return RichFacesInputNumberSlider.this.disabledHandle;
        }

        protected WebElement getHandleContainer() {
            return RichFacesInputNumberSlider.this.handleContainer;
        }

        public WebElement getHandleElement() {
            return RichFacesInputNumberSlider.this.handle;
        }

        public WebElement getMinimumElement() {
            return RichFacesInputNumberSlider.this.min;
        }

        public WebElement getMaximumElement() {
            return RichFacesInputNumberSlider.this.max;
        }

        public WebElement getTrackElement() {
            return RichFacesInputNumberSlider.this.trackComponent;
        }

        public WebElement getTooltipElement() {
            return RichFacesInputNumberSlider.this.tooltip;
        }

        public WebElement getSliderElement() {
            return RichFacesInputNumberSlider.this.sliderElement;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }
}

