/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.editor;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.ClearType;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.editor.Editor;
import org.richfaces.fragment.editor.toolbar.RichFacesEditorToolbar;

public class RichFacesEditor
implements Editor,
AdvancedVisibleComponentIteractions<AdvancedEditorInteractions> {
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private JavascriptExecutor executor;
    @FindBy(tagName="iframe")
    private WebElement frameElement;
    @FindBy(css=".cke_toolbox")
    private RichFacesEditorToolbar toolbar;
    private final AdvancedEditorInteractions advancedInteractions = new AdvancedEditorInteractions();

    @Override
    public AdvancedEditorInteractions advanced() {
        return this.advancedInteractions;
    }

    @Override
    public void clear() {
        this.advanced().clear(ClearType.JS);
    }

    protected JavascriptExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public String getText() {
        try {
            String string = this.switchToEditorActiveArea().getText();
            return string;
        }
        finally {
            this.browser.switchTo().defaultContent();
        }
    }

    protected WebElement switchToEditorActiveArea() {
        this.advanced().waitForFrameElementToBeVisible().perform();
        this.browser.switchTo().frame(this.advanced().getFrameElement());
        WebElement activeArea = this.browser.findElement(By.tagName((String)"body"));
        return activeArea;
    }

    @Override
    public void type(String text) {
        try {
            if (this.browser instanceof PhantomJSDriver) {
                if (!((Boolean)Utils.invokeRichFacesJSAPIFunction(this.advanced().getRootElement(), "isReadOnly()")).booleanValue()) {
                    this.switchToEditorActiveArea();
                    this.executor.executeScript(String.format("document.body.textContent = document.body.textContent + '%s'", text), new Object[0]);
                }
            } else {
                this.switchToEditorActiveArea().sendKeys(new CharSequence[]{text});
            }
        }
        finally {
            this.browser.switchTo().defaultContent();
        }
    }

    public class AdvancedEditorInteractions
    implements VisibleComponentInteractions {
        private long _timeoutForFrameElementToBeVisible = -1L;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void clear(ClearType clearType) {
            try {
                WebElement activeArea = RichFacesEditor.this.switchToEditorActiveArea();
                switch (clearType) {
                    case BACKSPACE: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    case DELETE: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    case ESCAPE_SQ: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    case JS: {
                        RichFacesEditor.this.getExecutor().executeScript("arguments[0].innerHTML = '';", new Object[]{activeArea});
                        return;
                    }
                    case WD: {
                        throw new UnsupportedOperationException("Unsupported Op.");
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown type of clear method " + (Object)((Object)clearType));
                    }
                }
            }
            finally {
                RichFacesEditor.this.browser.switchTo().defaultContent();
            }
        }

        public WebElement getFrameElement() {
            return RichFacesEditor.this.frameElement;
        }

        public WebElement getRootElement() {
            return RichFacesEditor.this.root;
        }

        public long getTimeoutForFrameElementToBeVisible() {
            return this._timeoutForFrameElementToBeVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesEditor.this.browser) : this._timeoutForFrameElementToBeVisible;
        }

        public RichFacesEditorToolbar getToolbar() {
            return RichFacesEditor.this.toolbar;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }

        public void setTimeoutForFrameElementToBeVisible(long timeoutInMilliseconds) {
            this._timeoutForFrameElementToBeVisible = timeoutInMilliseconds;
        }

        public WaitingWrapper waitForFrameElementToBeVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until().element(AdvancedEditorInteractions.this.getFrameElement()).is().visible();
                }
            }.withMessage("Waiting for inner frame element to be visible.").withTimeout(this.getTimeoutForFrameElementToBeVisible(), TimeUnit.MILLISECONDS);
        }
    }
}

