/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.notify;

import com.google.common.base.Predicate;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.GrapheneElementImpl;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.list.AbstractListComponent;
import org.richfaces.fragment.list.ListItem;
import org.richfaces.fragment.message.Message;
import org.richfaces.fragment.messages.Messages;
import org.richfaces.fragment.notify.Notify;
import org.richfaces.fragment.notify.NotifyMessage;
import org.richfaces.fragment.notify.RichFacesNotifyMessage;

public class RichFacesNotify
extends AbstractListComponent<NotifyMessageItemImpl>
implements Notify<NotifyMessageItemImpl> {
    @Drone
    private WebDriver driver;
    private String styleClass = "";
    private final AdvancedNotifyInteractionsImpl interactions = new AdvancedNotifyInteractionsImpl();

    @Override
    public AdvancedNotifyInteractionsImpl advanced() {
        return this.interactions;
    }

    private By getByForNotifyWithStyleClass(String additionalStyleClass) {
        return By.cssSelector((String)("div" + this.getSelectorForStyleClassOrEmpty(this.advanced().getNotifyMessageStyleClass()) + this.getSelectorForStyleClassOrEmpty(this.getStyleClass()) + this.getSelectorForStyleClassOrEmpty(additionalStyleClass)));
    }

    private String getSelectorForStyleClassOrEmpty(String styleClass) {
        return styleClass == null || styleClass.isEmpty() ? "" : "." + styleClass;
    }

    @Override
    public List<? extends NotifyMessage> getItems(Message.MessageType type) {
        switch (type) {
            case OK: {
                throw new UnsupportedOperationException("Notify messages does not support messages of type 'OK'.");
            }
            case INFORMATION: {
                return this.advanced().getInfoMessages();
            }
            case WARNING: {
                return this.advanced().getWarnMessages();
            }
            case ERROR: {
                return this.advanced().getErrorMessages();
            }
            case FATAL: {
                return this.advanced().getFatalMessages();
            }
        }
        throw new UnsupportedOperationException("Unknown type " + (Object)((Object)type));
    }

    @Override
    protected List<WebElement> getItemsElements() {
        return this.driver.findElements(this.getByForNotifyWithStyleClass(null));
    }

    protected String getStyleClass() {
        return this.styleClass;
    }

    protected void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public static class NotifyMessageItemImpl
    extends RichFacesNotifyMessage
    implements NotifyMessage,
    ListItem {
        @Override
        public GrapheneElement getRootElement() {
            return new GrapheneElementImpl((WebElement)this.advanced().getRootElement());
        }

        @Override
        public String getText() {
            return this.getRootElement().getText();
        }
    }

    public class AdvancedNotifyInteractionsImpl
    implements Messages.AdvancedMessagesInteractions {
        private static final String NOTIFY_MSG_STYLECLASS = "rf-ntf";
        private static final String NOTIFY_FATAL_MSG_STYLECLASS = "rf-ntf-ftl";
        private static final String NOTIFY_ERROR_MSG_STYLECLASS = "rf-ntf-err";
        private static final String NOTIFY_WARN_MSG_STYLECLASS = "rf-ntf-wrn";
        private static final String NOTIFY_INFO_MSG_STYLECLASS = "rf-ntf-inf";

        protected String getNotifyMessageStyleClass() {
            return NOTIFY_MSG_STYLECLASS;
        }

        protected String getNotifyMessageFatalStyleClass() {
            return NOTIFY_FATAL_MSG_STYLECLASS;
        }

        protected String getNotifyMessageErrorStyleClass() {
            return NOTIFY_ERROR_MSG_STYLECLASS;
        }

        protected String getNotifyMessageWarnStyleClass() {
            return NOTIFY_WARN_MSG_STYLECLASS;
        }

        protected String getNotifyMessageInfoStyleClass() {
            return NOTIFY_INFO_MSG_STYLECLASS;
        }

        public List<NotifyMessageItemImpl> getWarnMessages() {
            return RichFacesNotify.this.instantiateFragments(NotifyMessageItemImpl.class, RichFacesNotify.this.driver.findElements(RichFacesNotify.this.getByForNotifyWithStyleClass(this.getNotifyMessageWarnStyleClass())));
        }

        public List<NotifyMessageItemImpl> getErrorMessages() {
            return RichFacesNotify.this.instantiateFragments(NotifyMessageItemImpl.class, RichFacesNotify.this.driver.findElements(RichFacesNotify.this.getByForNotifyWithStyleClass(this.getNotifyMessageErrorStyleClass())));
        }

        public List<NotifyMessageItemImpl> getFatalMessages() {
            return RichFacesNotify.this.instantiateFragments(NotifyMessageItemImpl.class, RichFacesNotify.this.driver.findElements(RichFacesNotify.this.getByForNotifyWithStyleClass(this.getNotifyMessageFatalStyleClass())));
        }

        public List<NotifyMessageItemImpl> getInfoMessages() {
            return RichFacesNotify.this.instantiateFragments(NotifyMessageItemImpl.class, RichFacesNotify.this.driver.findElements(RichFacesNotify.this.getByForNotifyWithStyleClass(this.getNotifyMessageInfoStyleClass())));
        }

        public void setStyleClassToContain(String styleClass) {
            RichFacesNotify.this.setStyleClass(styleClass);
        }

        @Override
        public boolean isVisible() {
            return !RichFacesNotify.this.getItemsElements().isEmpty();
        }

        @Override
        public WaitingWrapper waitUntilMessagesAreNotVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AdvancedNotifyInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for notify to be not visible.");
        }

        @Override
        public WaitingWrapper waitUntilMessagesAreVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedNotifyInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for notify to be visible.");
        }
    }
}

