/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.joda.time.DateTime;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.calendar.DayPicker;
import org.richfaces.fragment.calendar.FooterControls;
import org.richfaces.fragment.calendar.HeaderControls;
import org.richfaces.fragment.calendar.TimeEditor;
import org.richfaces.fragment.calendar.YearAndMonthEditor;
import org.richfaces.fragment.common.Locations;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;

public class RichFacesAdvancedInlineCalendar {
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @FindBy(css="span[id$=Popup] > input[id$='InputDate']")
    private TextInputComponentImpl input;
    @FindBy(css="td[id$=Header]")
    private HeaderControls headerControls;
    @FindBy(css="td[id$=Footer]")
    private FooterControls footerControls;
    @FindBy(css="table[id$=Content] > tbody")
    private DayPicker dayPicker;
    @FindBy(css="table[id$=Editor]")
    private CalendarEditor calendarEditor;
    private long _timeoutForPopupToBeNotVisible = -1L;
    private long _timeoutPopupToBeVisible = -1L;

    protected CalendarEditor getCalendarEditor() {
        return this.calendarEditor;
    }

    public DayPicker getDayPicker() {
        return this.dayPicker;
    }

    public FooterControls getFooterControls() {
        this.footerControls.setCalendarEditor(this.getCalendarEditor());
        return this.footerControls;
    }

    public HeaderControls getHeaderControls() {
        this.headerControls.setCalendarEditor(this.getCalendarEditor());
        return this.headerControls;
    }

    public TextInputComponentImpl getInput() {
        return this.input;
    }

    public Locations getLocations() {
        return Utils.getLocations(this.getRoot());
    }

    public WebElement getRoot() {
        return this.root;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.getRoot());
    }

    public void setDateTime(DateTime dt) {
        this.getHeaderControls().openYearAndMonthEditor().selectDate(dt).confirmDate();
        this.getDayPicker().selectDayInMonth(dt);
        if (Utils.isVisible(this.getFooterControls().getTimeEditorOpenerElement())) {
            this.getFooterControls().openTimeEditor().setTime(dt, TimeEditor.SetValueBy.TYPING).confirmTime();
        }
    }

    public void setTimeoutForPopupToBeNotVisible(long timeoutInMilliseconds) {
        this._timeoutForPopupToBeNotVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForPopupToBeNotVisible() {
        return this._timeoutForPopupToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutForPopupToBeNotVisible;
    }

    public void setTimeoutForPopupToBeVisible(long timeoutInMilliseconds) {
        this._timeoutPopupToBeVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForPopupToBeVisible() {
        return this._timeoutPopupToBeVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutPopupToBeVisible;
    }

    public WaitingWrapper waitUntilIsNotVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.withTimeout(RichFacesAdvancedInlineCalendar.this.getTimeoutForPopupToBeNotVisible(), TimeUnit.MILLISECONDS).until((Predicate)new Predicate<WebDriver>(){

                    public boolean apply(WebDriver input) {
                        return !RichFacesAdvancedInlineCalendar.this.isVisible();
                    }
                });
            }
        }.withMessage("Waiting for calendar to be not visible.");
    }

    public WaitingWrapper waitUntilIsVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.withTimeout(RichFacesAdvancedInlineCalendar.this.getTimeoutForPopupToBeVisible(), TimeUnit.MILLISECONDS).until((Predicate)new Predicate<WebDriver>(){

                    public boolean apply(WebDriver input) {
                        return RichFacesAdvancedInlineCalendar.this.isVisible();
                    }
                });
            }
        }.withMessage("Waiting for calendar to be visible.");
    }

    public static class CalendarEditor {
        @Root
        private WebElement root;
        @FindBy(className="rf-cal-monthpicker-cnt")
        private YearAndMonthEditor dateEditor;
        @FindBy(className="rf-cal-timepicker-cnt")
        private TimeEditor timeEditor;

        public YearAndMonthEditor getDateEditor() {
            return this.dateEditor;
        }

        public boolean isVisible() {
            return Utils.isVisible(this.root);
        }

        public TimeEditor getTimeEditor() {
            return this.timeEditor;
        }
    }
}

