/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import com.google.common.base.Optional;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.calendar.Calendar;
import org.richfaces.fragment.calendar.RichFacesAdvancedInlineCalendar;
import org.richfaces.fragment.calendar.RichFacesAdvancedPopupCalendar;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.configuration.RichFacesPageFragmentsConfiguration;
import org.richfaces.fragment.configuration.RichFacesPageFragmentsConfigurationContext;

public class RichFacesCalendar
implements Calendar,
AdvancedInteractions<AdvancedCalendarInteractions> {
    @Root
    private WebElement root;
    private final AdvancedCalendarInteractions interactions = new AdvancedCalendarInteractions();
    private final RichFacesPageFragmentsConfiguration configuration = RichFacesPageFragmentsConfigurationContext.getProxy();
    private Calendar strategy = this.configuration.isUseJSInteractionStrategy() ? new CalendarJavaScriptStrategy() : new CalendarInteractiveStrategy();

    @Override
    public AdvancedCalendarInteractions advanced() {
        return this.interactions;
    }

    @Override
    public DateTime getDate() {
        return this.strategy.getDate();
    }

    @Override
    public void setDate(DateTime d) {
        this.strategy.setDate(d);
    }

    public class AdvancedCalendarInteractions {
        private static final String DATE_PATTERN_DEFAULT = "MMM d , yyyy";
        private String datePattern;

        public WebElement getRootElement() {
            return RichFacesCalendar.this.root;
        }

        private DateTimeFormatter getDatePattern() {
            return DateTimeFormat.forPattern((String)((String)Optional.fromNullable((Object)this.datePattern).or((Object)DATE_PATTERN_DEFAULT)));
        }

        public RichFacesAdvancedInlineCalendar getInlineCalendar() {
            if (!this.isPopup()) {
                return (RichFacesAdvancedInlineCalendar)Graphene.createPageFragment(RichFacesAdvancedInlineCalendar.class, (WebElement)RichFacesCalendar.this.advanced().getRootElement());
            }
            throw new RuntimeException("This is a popup calendar. Cannot get its inline version.");
        }

        public RichFacesAdvancedPopupCalendar getPopupCalendar() {
            if (this.isPopup()) {
                return (RichFacesAdvancedPopupCalendar)Graphene.createPageFragment(RichFacesAdvancedPopupCalendar.class, (WebElement)RichFacesCalendar.this.advanced().getRootElement());
            }
            throw new RuntimeException("This is an inline calendar. Cannot get its popup version.");
        }

        private boolean isPopup() {
            return Utils.isVisible((SearchContext)RichFacesCalendar.this.advanced().getRootElement(), (By)ByJQuery.selector((String)"span[id$='Popup']"));
        }

        public void setDatePattern(String datePattern) {
            this.datePattern = datePattern;
        }

        public void setInteractiveStrategy() {
            RichFacesCalendar.this.strategy = new CalendarInteractiveStrategy();
        }

        public void setJavaScriptStrategy() {
            RichFacesCalendar.this.strategy = new CalendarJavaScriptStrategy();
        }
    }

    private class CalendarJavaScriptStrategy
    implements Calendar {
        private CalendarJavaScriptStrategy() {
        }

        @Override
        public DateTime getDate() {
            return DateTime.parse((String)((String)Utils.invokeRichFacesJSAPIFunction(RichFacesCalendar.this.advanced().getRootElement(), "getValueAsString()")), (DateTimeFormatter)RichFacesCalendar.this.advanced().getDatePattern());
        }

        @Override
        public void setDate(DateTime d) {
            Utils.invokeRichFacesJSAPIFunction(RichFacesCalendar.this.advanced().getRootElement(), "setValue(new Date(" + d.getMillis() + "))");
        }
    }

    private class CalendarInteractiveStrategy
    implements Calendar {
        private CalendarInteractiveStrategy() {
        }

        @Override
        public DateTime getDate() {
            TextInputComponentImpl input = RichFacesCalendar.this.advanced().isPopup() ? RichFacesCalendar.this.advanced().getPopupCalendar().getInput() : RichFacesCalendar.this.advanced().getInlineCalendar().getInput();
            return RichFacesCalendar.this.advanced().getDatePattern().parseDateTime(input.getStringValue());
        }

        @Override
        public void setDate(DateTime d) {
            if (RichFacesCalendar.this.advanced().isPopup()) {
                RichFacesCalendar.this.advanced().getPopupCalendar().setDateTime(d);
            } else {
                RichFacesCalendar.this.advanced().getInlineCalendar().setDateTime(d);
            }
        }
    }
}

