/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.joda.time.DateTime;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.Validate;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;

public class YearAndMonthEditor {
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @FindByJQuery(value="div[id*='DateEditorLayoutM']:even")
    private List<WebElement> monthsEven;
    @FindByJQuery(value="div[id*='DateEditorLayoutM']:odd")
    private List<WebElement> monthsOdd;
    @FindBy(css="div[id*='DateEditorLayoutM'].rf-cal-edtr-btn-sel")
    private WebElement selectedMonth;
    @FindBy(css="div[id*='DateEditorLayoutY']")
    private List<WebElement> years;
    @FindByJQuery(value="div[id*='DateEditorLayoutY']:even")
    private List<WebElement> yearsEven;
    @FindByJQuery(value="div[id*='DateEditorLayoutY']:odd")
    private List<WebElement> yearsOdd;
    @FindBy(css="div[id*='DateEditorLayoutY0']")
    private WebElement firstYear;
    @FindBy(css="div[id*='DateEditorLayoutY'].rf-cal-edtr-btn-sel")
    private WebElement selectedYear;
    @FindByJQuery(value="[id$='DateEditorLayoutTR'] > td > div:eq(2)")
    private WebElement previousDecadeButtonElement;
    @FindByJQuery(value="[id$='DateEditorLayoutTR'] > td > div:eq(3)")
    private WebElement nextDecadeButtonElement;
    @FindBy(css="div[id$=DateEditorButtonOk]")
    private WebElement okButtonElement;
    @FindBy(css="div[id$=DateEditorButtonCancel]")
    private WebElement cancelButtonElement;
    private static final String SELECTED = "rf-cal-edtr-btn-sel";
    private long _timeoutForYearAndMonthEditorToBeNotVisible = -1L;
    private long _timeoutForYearAndMonthEditorToBeVisible = -1L;

    public void cancelDate() {
        this.getCancelButtonElement().click();
        this.waitUntilIsNotVisible().perform();
    }

    public void confirmDate() {
        this.getOkButtonElement().click();
        this.waitUntilIsNotVisible().perform();
    }

    public WebElement getCancelButtonElement() {
        return this.cancelButtonElement;
    }

    public DateTime getDate() {
        return new DateTime().withMonthOfYear(this.getSelectedMonthNumber().intValue()).withYear(this.getSelectedYearNumber().intValue());
    }

    public List<Integer> getDisplayedYears() {
        ArrayList inRightOrder = Lists.newArrayList(this.getYearsEven());
        inRightOrder.addAll(this.getYearsOdd());
        ArrayList<Integer> result = new ArrayList<Integer>(10);
        for (WebElement webElement : inRightOrder) {
            result.add(Integer.parseInt(webElement.getText().trim()));
        }
        return result;
    }

    public WebElement getNextDecadeButtonElement() {
        return this.nextDecadeButtonElement;
    }

    public WebElement getOkButtonElement() {
        return this.okButtonElement;
    }

    public WebElement getPreviousDecadeButtonElement() {
        return this.previousDecadeButtonElement;
    }

    public WebElement getRootElement() {
        return this.root;
    }

    protected String getSelectedClass() {
        return SELECTED;
    }

    public Integer getSelectedMonthNumber() {
        if (Utils.isVisible(this.getSelectedMonth())) {
            String id = this.getSelectedMonth().getAttribute("id");
            return Integer.parseInt(id.substring(id.lastIndexOf("M") + 1)) + 1;
        }
        return null;
    }

    public Integer getSelectedYearNumber() {
        if (Utils.isVisible(this.getSelectedYear())) {
            String year = this.getSelectedYear().getText();
            return Integer.parseInt(year);
        }
        return null;
    }

    public List<String> getShortMonthsLabels() {
        ArrayList inRightOrder = Lists.newArrayList(this.getMonthsEven());
        inRightOrder.addAll(this.getMonthsOdd());
        ArrayList<String> result = new ArrayList<String>(12);
        for (WebElement webElement : inRightOrder) {
            result.add(webElement.getText().trim());
        }
        return result;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.getRootElement());
    }

    public void nextDecade() {
        String firstBefore = this.getFirstYear().getText();
        this.getNextDecadeButtonElement().click();
        ((StringMatcher)Graphene.waitGui().withMessage("Waiting for decade to change.").until().element(this.getFirstYear()).text().not()).equalTo(firstBefore);
    }

    public void previousDecade() {
        String firstBefore = this.getFirstYear().getText();
        this.getPreviousDecadeButtonElement().click();
        ((StringMatcher)Graphene.waitGui().withMessage("Waiting for decade to change.").until().element(this.getFirstYear()).text().not()).equalTo(firstBefore);
    }

    public YearAndMonthEditor selectDate(DateTime date) {
        return this.selectDate(date.getMonthOfYear(), date.getYear());
    }

    private YearAndMonthEditor selectDate(int month, int year) {
        Validate.isTrue(month > 0 && month < 13, "Month number has to be in interval <1,12>", new Object[0]);
        this.selectMonth(month);
        this.selectYear(year);
        return this;
    }

    private void selectMonth(int month) {
        WebElement monthElement = this.getRootElement().findElement(By.cssSelector((String)("div[id*='DateEditorLayoutM" + (month - 1) + "']")));
        monthElement.click();
        Graphene.waitGui().withMessage("Waiting for month to be selected.").until().element(monthElement).attribute("class").contains(this.getSelectedClass());
    }

    private void selectYear(int year) {
        int yearsPickerSize = this.getYears().size();
        int yearInTheFirstColumn = Integer.parseInt(this.getFirstYear().getText());
        int diff = year - yearInTheFirstColumn;
        if (diff > 0 && diff >= yearsPickerSize) {
            while (diff > 0) {
                this.nextDecade();
                diff -= yearsPickerSize;
            }
        } else {
            while (diff < 0) {
                this.previousDecade();
                diff += yearsPickerSize;
            }
        }
        WebElement yearElement = this.getRootElement().findElement((By)ByJQuery.selector((String)("div[id*='DateEditorLayoutY']:contains('" + year + "')")));
        yearElement.click();
        Graphene.waitGui().withMessage("Waiting for year to be selected.").until().element(yearElement).attribute("class").contains(this.getSelectedClass());
    }

    public void settimeoutForYearAndMonthEditorToBeNotVisible(long timeoutInMilliseconds) {
        this._timeoutForYearAndMonthEditorToBeNotVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForYearAndMonthEditorToBeNotVisible() {
        return this._timeoutForYearAndMonthEditorToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutForYearAndMonthEditorToBeNotVisible;
    }

    public void setTimeoutForYearAndMonthEditorToBeVisible(long timeoutInMilliseconds) {
        this._timeoutForYearAndMonthEditorToBeVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForYearAndMonthEditorToBeVisible() {
        return this._timeoutForYearAndMonthEditorToBeVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutForYearAndMonthEditorToBeVisible;
    }

    public WaitingWrapper waitUntilIsNotVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                ((IsElementBuilder)wait.until().element(YearAndMonthEditor.this.getRootElement()).is().not()).visible();
            }
        }.withMessage("Waiting for year and month editor to be not visible.").withTimeout(this.getTimeoutForYearAndMonthEditorToBeNotVisible(), TimeUnit.MILLISECONDS);
    }

    public WaitingWrapper waitUntilIsVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.until().element(YearAndMonthEditor.this.getRootElement()).is().visible();
            }
        }.withMessage("Waiting for year and month editor to be visible.").withTimeout(this.getTimeoutForYearAndMonthEditorToBeVisible(), TimeUnit.MILLISECONDS);
    }

    protected List<WebElement> getMonthsEven() {
        return this.monthsEven;
    }

    protected List<WebElement> getMonthsOdd() {
        return this.monthsOdd;
    }

    protected WebElement getSelectedMonth() {
        return this.selectedMonth;
    }

    protected List<WebElement> getYears() {
        return this.years;
    }

    protected List<WebElement> getYearsEven() {
        return this.yearsEven;
    }

    protected List<WebElement> getYearsOdd() {
        return this.yearsOdd;
    }

    protected WebElement getFirstYear() {
        return this.firstYear;
    }

    protected WebElement getSelectedYear() {
        return this.selectedYear;
    }
}

