/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.common;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.richfaces.fragment.common.WaitingWrapper;

public abstract class WaitingWrapperImpl
implements WaitingWrapper {
    private long pollingInterval;
    private TimeUnit pollingIntervalTimeUnit;
    private long timeout;
    private TimeUnit timeoutTimeUnit;
    private String message;
    private FluentWait<WebDriver, Void> wait = Graphene.waitModel();

    @Override
    public final void perform() {
        if (this.pollingInterval != 0L && this.pollingIntervalTimeUnit != null) {
            this.wait = this.wait.pollingEvery(this.pollingInterval, this.pollingIntervalTimeUnit);
        }
        if (this.timeout != 0L && this.timeoutTimeUnit != null) {
            this.wait = this.wait.withTimeout(this.timeout, this.timeoutTimeUnit);
        }
        if (this.message != null) {
            this.wait = this.wait.withMessage(this.message);
        }
        this.wait.ignoring(StaleElementReferenceException.class);
        this.performWait(this.wait);
    }

    protected abstract void performWait(FluentWait<WebDriver, Void> var1);

    @Override
    public final WaitingWrapper pollingEvery(long interval, TimeUnit timeUnit) {
        this.pollingInterval = interval;
        this.pollingIntervalTimeUnit = timeUnit;
        return this;
    }

    @Override
    public final WaitingWrapper withMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public final WaitingWrapper withTimeout(long interval, TimeUnit timeUnit) {
        this.timeout = interval;
        this.timeoutTimeUnit = timeUnit;
        return this;
    }
}

