/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.common;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class TypeResolver {
    private static final Map<Class<?>, Reference<Map<TypeVariable<?>, Type>>> typeVariableCache = Collections.synchronizedMap(new WeakHashMap());
    private static boolean cacheEnabled = true;

    private TypeResolver() {
    }

    public static void enableCache() {
        cacheEnabled = true;
    }

    public static void disableCache() {
        typeVariableCache.clear();
        cacheEnabled = false;
    }

    public static <T, S extends T> Class<?> resolveRawArgument(Class<T> type, Class<S> subType) {
        return TypeResolver.resolveRawArgument(TypeResolver.resolveGenericType(type, subType), subType);
    }

    public static Class<?> resolveRawArgument(Type genericType, Class<?> subType) {
        Class<?>[] arguments = TypeResolver.resolveRawArguments(genericType, subType);
        if (arguments == null) {
            return Unknown.class;
        }
        if (arguments.length != 1) {
            throw new IllegalArgumentException("Expected 1 type argument on generic type " + genericType + " but found " + arguments.length);
        }
        return arguments[0];
    }

    public static <T, S extends T> Class<?>[] resolveRawArguments(Class<T> type, Class<S> subType) {
        return TypeResolver.resolveRawArguments(TypeResolver.resolveGenericType(type, subType), subType);
    }

    public static Class<?>[] resolveRawArguments(Type genericType, Class<?> subType) {
        Class[] result = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type[] arguments = paramType.getActualTypeArguments();
            result = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                result[i] = TypeResolver.resolveRawClass(arguments[i], subType);
            }
        } else if (genericType instanceof TypeVariable) {
            result = new Class[]{TypeResolver.resolveRawClass(genericType, subType)};
        }
        return result;
    }

    public static Type resolveGenericType(Class<?> type, Type subType) {
        Type superClass;
        Type result;
        Class rawType = subType instanceof ParameterizedType ? (Class)((ParameterizedType)subType).getRawType() : (Class)subType;
        if (type.equals(rawType)) {
            return subType;
        }
        if (type.isInterface()) {
            for (Type superInterface : rawType.getGenericInterfaces()) {
                if (superInterface == null || superInterface.equals(Object.class) || (result = TypeResolver.resolveGenericType(type, superInterface)) == null) continue;
                return result;
            }
        }
        if ((superClass = rawType.getGenericSuperclass()) != null && !superClass.equals(Object.class) && (result = TypeResolver.resolveGenericType(type, superClass)) != null) {
            return result;
        }
        return null;
    }

    public static Class<?> resolveRawClass(Type genericType, Class<?> subType) {
        if (genericType instanceof Class) {
            return genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return TypeResolver.resolveRawClass(((ParameterizedType)genericType).getRawType(), subType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            Class<?> compoment = TypeResolver.resolveRawClass(arrayType.getGenericComponentType(), subType);
            return Array.newInstance(compoment, 0).getClass();
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)genericType;
            genericType = TypeResolver.getTypeVariableMap(subType).get(variable);
            genericType = genericType == null ? TypeResolver.resolveBound(variable) : TypeResolver.resolveRawClass(genericType, subType);
        }
        return genericType instanceof Class ? (Class)genericType : Unknown.class;
    }

    private static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> targetType) {
        Map<TypeVariable<?>, Type> map;
        Reference<Map<TypeVariable<?>, Type>> ref = typeVariableCache.get(targetType);
        Map<TypeVariable<?>, Type> map2 = map = ref != null ? ref.get() : null;
        if (map == null) {
            Class<?> type;
            map = new HashMap();
            TypeResolver.buildTypeVariableMap(targetType.getGenericInterfaces(), map);
            Type genericType = targetType.getGenericSuperclass();
            for (type = targetType.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
                if (genericType instanceof ParameterizedType) {
                    TypeResolver.buildTypeVariableMap((ParameterizedType)genericType, map);
                }
                TypeResolver.buildTypeVariableMap(type.getGenericInterfaces(), map);
                genericType = type.getGenericSuperclass();
            }
            type = targetType;
            while (type.isMemberClass()) {
                genericType = type.getGenericSuperclass();
                if (genericType instanceof ParameterizedType) {
                    TypeResolver.buildTypeVariableMap((ParameterizedType)genericType, map);
                }
                type = type.getEnclosingClass();
            }
            if (cacheEnabled) {
                typeVariableCache.put(targetType, new WeakReference(map));
            }
        }
        return map;
    }

    private static void buildTypeVariableMap(Type[] types, Map<TypeVariable<?>, Type> map) {
        for (Type type : types) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                TypeResolver.buildTypeVariableMap(parameterizedType, map);
                Type rawType = parameterizedType.getRawType();
                if (!(rawType instanceof Class)) continue;
                TypeResolver.buildTypeVariableMap(((Class)rawType).getGenericInterfaces(), map);
                continue;
            }
            if (!(type instanceof Class)) continue;
            TypeResolver.buildTypeVariableMap(((Class)type).getGenericInterfaces(), map);
        }
    }

    private static void buildTypeVariableMap(ParameterizedType type, Map<TypeVariable<?>, Type> typeVariableMap) {
        if (type.getRawType() instanceof Class) {
            TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
            Type[] typeArguments = type.getActualTypeArguments();
            for (int i = 0; i < typeArguments.length; ++i) {
                TypeVariable variable = typeVariables[i];
                Type typeArgument = typeArguments[i];
                if (typeArgument instanceof Class) {
                    typeVariableMap.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof GenericArrayType) {
                    typeVariableMap.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof ParameterizedType) {
                    typeVariableMap.put(variable, typeArgument);
                    continue;
                }
                if (!(typeArgument instanceof TypeVariable)) continue;
                TypeVariable typeVariableArgument = (TypeVariable)typeArgument;
                Type resolvedType = typeVariableMap.get(typeVariableArgument);
                if (resolvedType == null) {
                    resolvedType = TypeResolver.resolveBound(typeVariableArgument);
                }
                typeVariableMap.put(variable, resolvedType);
            }
        }
    }

    public static Type resolveBound(TypeVariable<?> typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return Unknown.class;
        }
        Type bound = bounds[0];
        if (bound instanceof TypeVariable) {
            bound = TypeResolver.resolveBound((TypeVariable)bound);
        }
        return bound == Object.class ? Unknown.class : bound;
    }

    public static final class Unknown {
        private Unknown() {
        }
    }
}

