/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.select;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.ClearType;
import org.richfaces.fragment.common.ScrollingType;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.select.Select;
import org.richfaces.fragment.select.SelectSuggestions;

public class RichFacesSelect
implements Select,
AdvancedVisibleComponentIteractions<AdvancedSelectInteractions> {
    @Drone
    private WebDriver driver;
    @Root
    private WebElement root;
    @FindBy(className="rf-sel-inp")
    private TextInputComponentImpl input;
    @FindBy(className="rf-sel-btn-arrow")
    private WebElement showButton;
    @FindBy(className="rf-sel-shdw")
    private GrapheneElement localPopup;
    private static final ByJQuery GLOBAL_POPUP = ByJQuery.selector((String)"div.rf-sel-shdw:visible");
    private final AdvancedSelectInteractions interactions = new AdvancedSelectInteractions();
    private final SelectSuggestionsImpl selectSuggestions = new SelectSuggestionsImpl();

    @Override
    public AdvancedSelectInteractions advanced() {
        return this.interactions;
    }

    private SelectSuggestionsImpl getSuggestions() {
        this.advanced().waitUntilSuggestionsAreVisible().perform();
        return this.selectSuggestions;
    }

    @Override
    public SelectSuggestions openSelect() {
        if (!Utils.isVisible((SearchContext)this.driver, (By)this.advanced().getGlobalPopup()) && !Utils.isVisible((WebElement)this.advanced().getLocalPopup())) {
            (this.advanced().getOpenByInputClick() ? this.advanced().getInput().advanced().getInputElement() : this.advanced().getShowButtonElement()).click();
        }
        return this.getSuggestions();
    }

    @Override
    public SelectSuggestions type(String text) {
        this.advanced().getInput().advanced().clear(ClearType.DEFAULT_CLEAR_TYPE).sendKeys(text);
        return this.getSuggestions();
    }

    public class AdvancedSelectInteractions
    implements VisibleComponentInteractions {
        private final ScrollingType DEFAULT_SCROLLING_TYPE;
        private static final boolean DEFAULT_OPEN_BY_INPUT_CLICK = true;
        private ScrollingType scrollingType;
        private Boolean openByInputClick;
        private long _timeoutForSuggestionsToBeNotVisible;
        private long _timeoutForSuggestionsToBeVisible;

        public AdvancedSelectInteractions() {
            this.scrollingType = this.DEFAULT_SCROLLING_TYPE = ScrollingType.BY_MOUSE;
            this.openByInputClick = true;
            this._timeoutForSuggestionsToBeNotVisible = -1L;
            this._timeoutForSuggestionsToBeVisible = -1L;
        }

        public TextInputComponentImpl getInput() {
            return RichFacesSelect.this.input;
        }

        protected boolean getOpenByInputClick() {
            return this.openByInputClick;
        }

        protected GrapheneElement getLocalPopup() {
            return RichFacesSelect.this.localPopup;
        }

        protected ByJQuery getGlobalPopup() {
            return GLOBAL_POPUP;
        }

        public WebElement getRootElement() {
            return RichFacesSelect.this.root;
        }

        protected ScrollingType getScrollingType() {
            return this.scrollingType;
        }

        public WebElement getShowButtonElement() {
            return RichFacesSelect.this.showButton;
        }

        public List<WebElement> getSuggestionsElements() {
            return RichFacesSelect.this.driver.findElement((By)RichFacesSelect.this.advanced().getGlobalPopup()).findElements(By.className((String)"rf-sel-opt"));
        }

        public boolean isPopupPresent() {
            return !RichFacesSelect.this.driver.findElements((By)this.getGlobalPopup()).isEmpty() && !RichFacesSelect.this.advanced().getLocalPopup().isPresent();
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }

        public void setOpenByInputClick() {
            this.openByInputClick = true;
        }

        public void setOpenByInputClick(boolean openByClickOnInput) {
            this.openByInputClick = openByClickOnInput;
        }

        public void setScrollingType() {
            this.scrollingType = this.DEFAULT_SCROLLING_TYPE;
        }

        public void setScrollingType(ScrollingType type) {
            this.scrollingType = type;
        }

        public WaitingWrapper waitUntilSuggestionsAreNotVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until().element((WebElement)AdvancedSelectInteractions.this.getLocalPopup()).is().present();
                }
            }.withMessage("Waiting for popup to be not visible").withTimeout(this.getTimeoutForSuggestionsToBeNotVisible(), TimeUnit.MILLISECONDS);
        }

        public WaitingWrapper waitUntilSuggestionsAreVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedSelectInteractions.this.isPopupPresent();
                        }
                    });
                }
            }.withMessage("Waiting for popup to be visible").withTimeout(this.getTimeoutForSuggestionsToBeVisible(), TimeUnit.MILLISECONDS);
        }

        public void setTimeoutForSuggestionsToBeNotVisible(long timeoutInMilliseconds) {
            this._timeoutForSuggestionsToBeNotVisible = timeoutInMilliseconds;
        }

        public long getTimeoutForSuggestionsToBeNotVisible() {
            return this._timeoutForSuggestionsToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesSelect.this.driver) : this._timeoutForSuggestionsToBeNotVisible;
        }

        public void setTimeoutForSuggestionsToBeVisible(long timeoutInMilliseconds) {
            this._timeoutForSuggestionsToBeVisible = timeoutInMilliseconds;
        }

        public long getTimeoutForSuggestionsToBeVisible() {
            return this._timeoutForSuggestionsToBeVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesSelect.this.driver) : this._timeoutForSuggestionsToBeVisible;
        }
    }

    public class SelectSuggestionsImpl
    implements SelectSuggestions {
        @Override
        public void select(ChoicePicker picker) {
            WebElement foundValue = picker.pick(RichFacesSelect.this.advanced().getSuggestionsElements());
            if (foundValue == null) {
                throw new RuntimeException("The value was not found by " + picker.toString());
            }
            if (RichFacesSelect.this.advanced().getScrollingType() == ScrollingType.BY_KEYS) {
                this.selectWithKeys(foundValue);
            } else {
                new Actions(RichFacesSelect.this.driver).moveToElement(foundValue).click(foundValue).perform();
            }
            RichFacesSelect.this.advanced().waitUntilSuggestionsAreNotVisible().perform();
            RichFacesSelect.this.advanced().getInput().advanced().trigger("blur");
        }

        @Override
        public void select(String match) {
            this.select(ChoicePickerHelper.byVisibleText().match(match));
        }

        @Override
        public void select(int index) {
            this.select(ChoicePickerHelper.byIndex().index(index));
        }

        private void selectWithKeys(WebElement foundValue) {
            boolean skip = RichFacesSelect.this.advanced().getSuggestionsElements().get(0).getAttribute("class").contains("rf-sel-sel");
            int index = Utils.getIndexOfElement(foundValue);
            int steps = index + (skip ? 0 : 1);
            Actions actions = new Actions(RichFacesSelect.this.driver);
            for (int i = 0; i < steps; ++i) {
                actions.sendKeys(new CharSequence[]{Keys.ARROW_DOWN});
            }
            actions.sendKeys(foundValue, new CharSequence[]{Keys.RETURN}).perform();
        }
    }
}

