/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.common;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.WebElementUtils;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.Locations;

public final class Utils {
    public static final By BY_BODY = By.tagName((String)"body");
    public static final By BY_HTML = By.tagName((String)"html");

    public static JavascriptExecutor getExecutorFromElement(WebElement element) {
        Preconditions.checkNotNull((Object)element, (Object)"The element cannot be null.");
        if (element instanceof GrapheneProxyInstance) {
            GrapheneContext context = ((GrapheneProxyInstance)element).getContext();
            return (JavascriptExecutor)context.getWebDriver(new Class[]{JavascriptExecutor.class});
        }
        throw new RuntimeException("Cannot obtain JavascriptExecutor from element which is not an instance of GrapheneProxyInstance.");
    }

    public static int getIndexOfElement(WebElement element) {
        return Integer.valueOf(Utils.returningJQ(Utils.getExecutorFromElement(element), "index()", element));
    }

    public static WebElement getAncestorOfElement(WebElement element) {
        return Utils.getAncestorOfElement(element, "*");
    }

    public static WebElement getAncestorOfElement(WebElement element, String tagNameOfAncestorElement) {
        return Utils.getXpathLocatedElement(element, tagNameOfAncestorElement, "ancestor", false);
    }

    public static WebElement getNextSiblingOfElement(WebElement element) {
        return Utils.getNextSiblingOfElement(element, "*");
    }

    public static WebElement getNextSiblingOfElement(WebElement element, String tagNameofSibling) {
        return Utils.getXpathLocatedElement(element, tagNameofSibling, "following-sibling", true);
    }

    public static WebElement getPreviousSiblingOfElement(WebElement element) {
        return Utils.getPreviousSiblingOfElement(element, "*");
    }

    public static WebElement getPreviousSiblingOfElement(WebElement element, String tagNameofSibling) {
        return Utils.getXpathLocatedElement(element, tagNameofSibling, "preceding-sibling", false);
    }

    private static WebElement getXpathLocatedElement(WebElement fromElement, String tagnameOfSearchedElement, String searchFunction, boolean isFirst) {
        List elements = WebElementUtils.findElementsLazily((By)By.xpath((String)String.format("./%s::%s", searchFunction, tagnameOfSearchedElement)), (SearchContext)fromElement);
        return (WebElement)elements.get(isFirst ? 0 : elements.size() - 1);
    }

    public static <T> Optional<T> getComponentOption(WebElement rootOfComponent, String option) {
        return Optional.of(Utils.invokeRichFacesJSAPIFunction(rootOfComponent, "options." + option));
    }

    public static <T> Optional<T> getComponentOptionDocumentObjectSafe(WebElement rootOfComponent, String option) {
        if (!((Boolean)Utils.invokeRichFacesJSAPIFunction(rootOfComponent, "options." + option + " == document")).booleanValue()) {
            return Utils.getComponentOption(rootOfComponent, option);
        }
        return Optional.fromNullable(null);
    }

    public static Locations getLocations(WebElement root) {
        Preconditions.checkNotNull((Object)root, (Object)"The element cannot be null.");
        Point topLeft = root.getLocation();
        Dimension dimension = root.getSize();
        Point topRight = topLeft.moveBy(dimension.getWidth(), 0);
        Point bottomRight = topRight.moveBy(0, dimension.getHeight());
        Point bottomLeft = topLeft.moveBy(0, dimension.getHeight());
        return new Locations(topLeft, topRight, bottomLeft, bottomRight);
    }

    public static String getTextFromHiddenElement(JavascriptExecutor executor, WebElement element) {
        return Utils.returningJQ(executor, "text()", element);
    }

    public static String getTextFromHiddenElement(WebElement element) {
        return Utils.getTextFromHiddenElement(Utils.getExecutorFromElement(element), element);
    }

    public static <T> T invokeRichFacesJSAPIFunction(WebElement componentRoot, String functionWithParams) {
        return (T)Utils.getExecutorFromElement(componentRoot).executeScript("return RichFaces.component(arguments[0])." + functionWithParams, new Object[]{componentRoot});
    }

    public static boolean isVisible(WebElement e) {
        try {
            boolean result = false;
            result = e.isDisplayed();
            return result;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    public static boolean isVisible(SearchContext searchContext, By by) {
        try {
            boolean result = false;
            result = searchContext.findElement(by).isDisplayed();
            return result;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    public static void jQ(JavascriptExecutor executor, String cmd, WebElement element) {
        Preconditions.checkNotNull((Object)executor, (Object)"The executor cannot be null.");
        Preconditions.checkNotNull((Object)cmd, (Object)"The command cannot be null.");
        Preconditions.checkNotNull((Object)element, (Object)"The element cannot be null.");
        String jQueryCmd = String.format("jQuery(arguments[0]).%s", cmd);
        executor.executeScript(jQueryCmd, new Object[]{Utils.unwrap(element)});
    }

    public static void jQ(String cmd, WebElement element) {
        Utils.jQ(Utils.getExecutorFromElement(element), cmd, element);
    }

    public static String returningJQ(JavascriptExecutor executor, String cmd, WebElement element) {
        Preconditions.checkNotNull((Object)executor, (Object)"The executor cannot be null.");
        Preconditions.checkNotNull((Object)cmd, (Object)"The command cannot be null.");
        Preconditions.checkNotNull((Object)element, (Object)"The element cannot be null.");
        String jQueryCmd = String.format("return jQuery(arguments[0]).%s;", cmd);
        return String.valueOf(executor.executeScript(jQueryCmd, new Object[]{Utils.unwrap(element)}));
    }

    public static String returningJQ(String cmd, WebElement element) {
        return Utils.returningJQ(Utils.getExecutorFromElement(element), cmd, element);
    }

    private static boolean _tolerantAssertPointEquals(Point p1, Point p2, int xTolerance, int yTolerance) {
        return Math.abs(p1.x - p2.x) <= xTolerance && Math.abs(p1.y - p2.y) <= yTolerance;
    }

    public static void tolerantAssertPointEquals(Point p1, Point p2, int xTolerance, int yTolerance, String message) {
        if (!Utils._tolerantAssertPointEquals(p1, p2, xTolerance, yTolerance)) {
            throw new AssertionError((Object)("The points are not equal or not in tolerance.\n The tolerance for x axis was: " + xTolerance + ". The tolerance for y axis was: " + yTolerance + ".\n" + "First point: " + p1 + "\n" + "Second point: " + p2 + ".\n" + message));
        }
    }

    public static void tolerantAssertLocationsEquals(Locations l1, Locations l2, int xTolerance, int yTolerance, String message) {
        Iterator<Point> it1 = l1.iterator();
        Iterator<Point> it2 = l2.iterator();
        while (it1.hasNext()) {
            Point p2;
            Point p1 = it1.next();
            if (!Utils._tolerantAssertPointEquals(p1, p2 = it2.next(), xTolerance, yTolerance)) {
                throw new AssertionError((Object)("The locations are not equal or are not in tolerance.\nFirst location: " + l1 + ".\n" + "Second location: " + l2 + ".\n" + "Diverging point: " + p1 + " (first), " + p2 + " (second).\n" + message));
            }
        }
    }

    public static void tolerantAssertLocationsEquals(WebElement element, Locations l2, int xTolerance, int yTolerance, String message) {
        Utils.tolerantAssertLocationsEquals(Utils.getLocations(element), l2, xTolerance, yTolerance, message);
    }

    public static void triggerJQ(JavascriptExecutor executor, String event, WebElement element) {
        Utils.jQ(executor, String.format("trigger('%s')", event), element);
    }

    public static void triggerJQ(String event, WebElement element) {
        Utils.triggerJQ(Utils.getExecutorFromElement(element), event, element);
    }

    public static WebElement unwrap(WebElement element) {
        Preconditions.checkNotNull((Object)element, (Object)"The element cannot be null.");
        WebElement result = element;
        while (GrapheneProxy.isProxyInstance((Object)result)) {
            result = (WebElement)((GrapheneProxyInstance)result).unwrap();
        }
        return result;
    }

    public static long getWaitGUIDefaultTimeout(WebDriver browser) {
        return 1000L * ((GrapheneProxyInstance)browser).getContext().getConfiguration().getWaitGuiInterval();
    }

    public static long getWaitAjaxDefaultTimeout(WebDriver browser) {
        return 1000L * ((GrapheneProxyInstance)browser).getContext().getConfiguration().getWaitAjaxInterval();
    }
}

