/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.joda.time.DateTime;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.calendar.TimeSpinner;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;

public class TimeEditor {
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @FindByJQuery(value=".rf-cal-timepicker-inp table table:has('input[id$=TimeHours]')")
    private TimeSpinner.TimeSpinner12 hoursSpinner12;
    @FindByJQuery(value=".rf-cal-timepicker-inp table table:has('input[id$=TimeHours]')")
    private TimeSpinner.TimeSpinner24 hoursSpinner24;
    @FindByJQuery(value=".rf-cal-timepicker-inp table table:has('input[id$=TimeMinutes]')")
    private TimeSpinner.TimeSpinner60 minutesSpinner;
    @FindByJQuery(value=".rf-cal-timepicker-inp table table:has('input[id$=TimeSeconds]')")
    private TimeSpinner.TimeSpinner60 secondsSpinner;
    @FindByJQuery(value=".rf-cal-timepicker-inp table table:has('input[id$=TimeSign]')")
    private TimeSpinner.TimeSignSpinner timeSignSpinner;
    @FindBy(css="div[id$=TimeEditorButtonOk]")
    private GrapheneElement okButtonElement;
    @FindBy(css="div[id$=TimeEditorButtonCancel]")
    private GrapheneElement cancelButtonElement;
    private static final int defaultHours = 12;
    private static final int defaultMinutes = 0;
    private static final int defaultSeconds = 0;
    private long _timeoutForTimeEditorToBeNotVisible = -1L;
    private long _timeoutForTimeEditorToBeVisible = -1L;

    public WebElement getRootElement() {
        return this.root;
    }

    protected int getDefaultHours() {
        return 12;
    }

    protected int getDefaultMinutes() {
        return 0;
    }

    protected int getDefaultSeconds() {
        return 0;
    }

    protected TimeSpinner.TimeSpinner12 getHoursSpinner12() {
        return this.hoursSpinner12;
    }

    protected TimeSpinner.TimeSpinner24 getHoursSpinner24() {
        return this.hoursSpinner24;
    }

    public void cancelTime() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with TimePicker. Ensure that it it is opened.");
        }
        if (!this.getCancelButtonElement().isDisplayed()) {
            throw new RuntimeException("Cancel button is not visible.");
        }
        this.getCancelButtonElement().click();
        this.waitUntilIsNotVisible().perform();
    }

    public void confirmTime() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with TimePicker. Ensure that it it is opened.");
        }
        if (!this.getOkButtonElement().isDisplayed()) {
            throw new RuntimeException("Ok button is not visible.");
        }
        this.getOkButtonElement().click();
        this.waitUntilIsNotVisible().perform();
    }

    public WebElement getCancelButtonElement() {
        return this.cancelButtonElement;
    }

    private TimeSpinner<Integer> getHoursSpinner() {
        if (this.getTimeSignSpinner() == null) {
            if (this.getHoursSpinner24().isVisible()) {
                return this.getHoursSpinner24();
            }
        } else if (this.getHoursSpinner12().isVisible()) {
            return this.getHoursSpinner12();
        }
        return null;
    }

    private TimeSpinner<Integer> getMinutesSpinner() {
        if (this.minutesSpinner.isVisible()) {
            return this.minutesSpinner;
        }
        return null;
    }

    public WebElement getOkButtonElement() {
        return this.okButtonElement;
    }

    private TimeSpinner<Integer> getSecondsSpinner() {
        if (this.secondsSpinner.isVisible()) {
            return this.secondsSpinner;
        }
        return null;
    }

    public DateTime getTime() {
        int seconds = this.getSecondsSpinner() != null ? this.getSecondsSpinner().getValue().intValue() : this.getDefaultSeconds();
        int minutes = this.getMinutesSpinner() != null ? this.getMinutesSpinner().getValue().intValue() : this.getDefaultMinutes();
        int hours = this.getHoursSpinner() != null ? this.getHoursSpinner().getValue().intValue() : this.getDefaultHours();
        DateTime result = new DateTime().withHourOfDay(hours).withMinuteOfHour(minutes).withSecondOfMinute(seconds);
        TimeSpinner.TimeSignSpinner tss = this.getTimeSignSpinner();
        if (tss != null) {
            switch (tss.getValue()) {
                case AM: {
                    if (result.getHourOfDay() != 12) break;
                    result = result.minusHours(12);
                    break;
                }
                case PM: {
                    if (result.getHourOfDay() == 12) break;
                    result = result.plusHours(12);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown switch");
                }
            }
        }
        return result;
    }

    private TimeSpinner.TimeSignSpinner getTimeSignSpinner() {
        if (this.timeSignSpinner.isVisible()) {
            return this.timeSignSpinner;
        }
        return null;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.getRootElement());
    }

    private TimeEditor setTime(int hours, int minutes, int seconds, SetValueBy by) {
        TimeSpinner.TimeSign timeSign = null;
        TimeSpinner<Integer> actSecondsSpinner = this.getSecondsSpinner();
        TimeSpinner.TimeSignSpinner acttimeSignSpinner = this.getTimeSignSpinner();
        if (acttimeSignSpinner != null) {
            timeSign = TimeSpinner.TimeSign.AM;
            if (hours >= 12) {
                timeSign = TimeSpinner.TimeSign.PM;
            }
            if (hours > 12) {
                hours -= 12;
            }
            if (hours == 0) {
                hours = 12;
            }
        }
        this.getHoursSpinner().setValueBy(hours, by);
        this.getMinutesSpinner().setValueBy(minutes, by);
        if (actSecondsSpinner != null) {
            actSecondsSpinner.setValueBy(seconds, by);
        }
        if (acttimeSignSpinner != null) {
            acttimeSignSpinner.setValueBy(timeSign, by);
        }
        return this;
    }

    public TimeEditor setTime(DateTime time, SetValueBy inputType) {
        return this.setTime(time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute(), inputType);
    }

    public void setTimeouFortTimeEditorIsNotVisible(long timeoutInMilliseconds) {
        this._timeoutForTimeEditorToBeNotVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForTimeEditorToBeNotVisible() {
        return this._timeoutForTimeEditorToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutForTimeEditorToBeNotVisible;
    }

    public void setTimeoutForTimeEditorToBeVisible(long timeoutInMilliseconds) {
        this._timeoutForTimeEditorToBeVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForTimeEditorToBeVisible() {
        return this._timeoutForTimeEditorToBeVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutForTimeEditorToBeVisible;
    }

    public WaitingWrapper waitUntilIsNotVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                ((IsElementBuilder)wait.until().element(TimeEditor.this.getRootElement()).is().not()).visible();
            }
        }.withMessage("Time editor to be not visible.").withTimeout(this.getTimeoutForTimeEditorToBeNotVisible(), TimeUnit.MILLISECONDS);
    }

    public WaitingWrapper waitUntilIsVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.until().element(TimeEditor.this.getRootElement()).is().visible();
            }
        }.withMessage("Time editor to be visible.").withTimeout(this.getTimeoutForTimeEditorToBeVisible(), TimeUnit.MILLISECONDS);
    }

    public static enum SetValueBy {
        TYPING,
        BUTTONS;

    }
}

