/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.contextMenu;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Event;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.contextMenu.PopupMenu;

public abstract class AbstractPopupMenu
implements PopupMenu,
AdvancedVisibleComponentIteractions<AdvancedPopupMenuInteractions> {
    @Drone
    private WebDriver browser;
    @Root
    private WebElement root;

    protected String getNameOfFragment() {
        return this.getClass().getSimpleName();
    }

    protected WebElement getRootElement() {
        return this.root;
    }

    @Override
    public abstract AdvancedPopupMenuInteractions advanced();

    @Override
    public void selectItem(ChoicePicker picker) {
        this.advanced().show();
        WebElement item = picker.pick(this.advanced().getMenuItemElements());
        if (item == null) {
            throw new IllegalArgumentException("There is no such option to be selected, which satisfied the given rules!");
        }
        item.click();
    }

    @Override
    public void selectItem(String header) {
        this.selectItem(ChoicePickerHelper.byVisibleText().match(header));
    }

    @Override
    public void selectItem(int index) {
        this.selectItem(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public void selectItem(ChoicePicker picker, WebElement target) {
        this.advanced().setTarget(target);
        this.selectItem(picker);
    }

    @Override
    public void selectItem(String header, WebElement target) {
        this.advanced().setTarget(target);
        this.selectItem(header);
    }

    @Override
    public void selectItem(int index, WebElement target) {
        this.advanced().setTarget(target);
        this.selectItem(index);
    }

    public abstract class AdvancedPopupMenuInteractions
    implements VisibleComponentInteractions {
        private final Event DEFAULT_INVOKE_EVENT;
        private Event invokeEvent;
        private static final int DEFAULT_HIDEDELAY = 300;
        private int hideDelay;
        private static final int DEFAULT_SHOWDELAY = 50;
        private int showDelay;
        private WebElement target;
        private long _timeoutForPopupMenuToBeNotVisible;
        private long _timeoutForPopupMenuToBeVisible;

        public AdvancedPopupMenuInteractions() {
            this.invokeEvent = this.DEFAULT_INVOKE_EVENT = Event.CONTEXTCLICK;
            this.hideDelay = 300;
            this.showDelay = 50;
            this._timeoutForPopupMenuToBeNotVisible = -1L;
            this._timeoutForPopupMenuToBeVisible = -1L;
        }

        public void hide() {
            if (!this.getMenuPopup().isDisplayed()) {
                throw new IllegalStateException("You are attemting to dismiss the " + AbstractPopupMenu.this.getNameOfFragment() + ", however, no " + AbstractPopupMenu.this.getNameOfFragment() + " is displayed at the moment!");
            }
            AbstractPopupMenu.this.browser.findElement(Utils.BY_HTML).click();
            this.waitUntilIsNotVisible().perform();
        }

        public List<WebElement> getItemsElements() {
            return Collections.unmodifiableList(this.getMenuItemElements());
        }

        public abstract List<WebElement> getMenuItemElements();

        protected abstract WebElement getScriptElement();

        public abstract WebElement getMenuPopup();

        protected int getShowDelay() {
            return this.showDelay;
        }

        public WebElement getTargetElement() {
            if (this.target == null) {
                this.setTarget();
            }
            return this.target;
        }

        public void show() {
            this.show(this.getTargetElement());
        }

        public void show(WebElement givenTarget) {
            new Actions(AbstractPopupMenu.this.browser).moveToElement(givenTarget).triggerEventByWD(this.getShowEvent(), givenTarget).perform();
            AbstractPopupMenu.this.advanced().waitUntilIsVisible().perform();
        }

        public void show(WebElement givenTarget, Point location) {
            throw new UnsupportedOperationException("File a feature request to have this, or even better implement it:)");
        }

        public void setHideDelay() {
            this.hideDelay = 300;
        }

        public void setHideDelay(int newHideDelayInMillis) {
            if (newHideDelayInMillis < 0) {
                throw new IllegalArgumentException("Can not be negative!");
            }
            this.hideDelay = newHideDelayInMillis;
        }

        protected Event getDefaultShowEvent() {
            return this.DEFAULT_INVOKE_EVENT;
        }

        protected Event getShowEvent() {
            return this.invokeEvent;
        }

        public void setShowEvent() {
            this.setShowEvent(this.getDefaultShowEvent());
        }

        public void setShowEvent(Event newShowEvent) {
            if (newShowEvent == null) {
                throw new IllegalArgumentException("Parameter newInvokeEvent can not be null!");
            }
            this.invokeEvent = newShowEvent;
        }

        public void setShowEventFromWidget() {
            Optional event = Utils.getComponentOption(AbstractPopupMenu.this.root, "showEvent");
            this.setShowEvent(new Event((String)event.or((Object)this.getDefaultShowEvent().getEventName())));
        }

        public void setShowDelay() {
            this.showDelay = 50;
        }

        public void setShowDelay(int newShowDelayInMillis) {
            if (newShowDelayInMillis < 0) {
                throw new IllegalArgumentException("Can not be negative!");
            }
            this.showDelay = newShowDelayInMillis;
        }

        public void setTarget() {
            this.target = AbstractPopupMenu.this.getRootElement();
        }

        public void setTarget(WebElement target) {
            this.target = target;
        }

        public void setTargetFromWidget() {
            String targetId = (String)Utils.getComponentOption(AbstractPopupMenu.this.getRootElement(), "target").orNull();
            this.target = targetId != null ? AbstractPopupMenu.this.browser.findElement(By.id((String)targetId)) : AbstractPopupMenu.this.getRootElement();
        }

        public void setTimeoutForPopupMenuToBeNotVisible(long timeoutInMilliseconds) {
            this._timeoutForPopupMenuToBeNotVisible = timeoutInMilliseconds;
        }

        public long getTimeoutForPopupMenuToBeNotVisible() {
            return this._timeoutForPopupMenuToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(AbstractPopupMenu.this.browser) : this._timeoutForPopupMenuToBeNotVisible;
        }

        public void setTimeoutForPopupMenuToBeVisible(long timeoutInMilliseconds) {
            this._timeoutForPopupMenuToBeVisible = timeoutInMilliseconds;
        }

        public long getTimeoutForPopupMenuToBeVisible() {
            return this._timeoutForPopupMenuToBeVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(AbstractPopupMenu.this.browser) : this._timeoutForPopupMenuToBeVisible;
        }

        public WaitingWrapper waitUntilIsNotVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    ((IsElementBuilder)wait.until().element(AdvancedPopupMenuInteractions.this.getMenuPopup()).is().not()).visible();
                }
            }.withMessage("Waiting for menu to hide.").withTimeout((long)this.hideDelay + this.getTimeoutForPopupMenuToBeNotVisible(), TimeUnit.MILLISECONDS);
        }

        public WaitingWrapper waitUntilIsVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until().element(AdvancedPopupMenuInteractions.this.getMenuPopup()).is().visible();
                }
            }.withMessage("The " + AbstractPopupMenu.this.getNameOfFragment() + " did not show in the given timeout!").withTimeout((long)this.showDelay + this.getTimeoutForPopupMenuToBeVisible(), TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(AbstractPopupMenu.this.getRootElement());
        }
    }
}

