/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.fileUpload;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.fileUpload.FileUpload;
import org.richfaces.fragment.fileUpload.FileUploadItem;
import org.richfaces.fragment.list.AbstractListComponent;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.list.RichFacesListItem;

public class RichFacesFileUpload
implements FileUpload,
AdvancedVisibleComponentIteractions<AdvancedFileUploadInteractions> {
    @Root
    private WebElement rootElement;
    @FindBy(className="rf-fu-lst")
    private RichFacesFileUploadList items;
    @FindBy(className="rf-fu-btn-cnt-add")
    private WebElement addButtonElement;
    @FindBy(className="rf-fu-btn-cnt-add-dis")
    private WebElement disabledAddButtonElement;
    @FindBy(className="rf-fu-btn-clr")
    private WebElement clearAllButtonElement;
    @FindBy(className="rf-fu-btn-cnt-upl")
    private WebElement uploadButtonElement;
    @FindByJQuery(value=".rf-fu-inp:last")
    private WebElement fileInputElement;
    @FindBy(className="rf-fu-inp")
    private List<WebElement> fileInputElements;
    @FindBy(css=".rf-fu-btn-add > span")
    private WebElement inputContainer;
    @Drone
    private WebDriver browser;
    private final AdvancedFileUploadInteractions interactions = new AdvancedFileUploadInteractions();

    @Override
    public boolean addFile(File file) {
        final int expectedSize = this.advanced().getFileInputElements().size() + 1;
        String containerStyleClassBefore = this.advanced().getInputContainer().getAttribute("class");
        Utils.jQ("attr('class', '')", this.advanced().getInputContainer());
        if (this.browser instanceof PhantomJSDriver) {
            ((PhantomJSDriver)this.browser).executePhantomJS("var page = this; page.uploadFile('input[type=file]', '" + file.getAbsolutePath() + "');", new Object[0]);
        } else {
            this.advanced().getFileInputElement().sendKeys(new CharSequence[]{file.getAbsolutePath()});
        }
        Utils.jQ("attr('class', '" + containerStyleClassBefore + "')", this.advanced().getInputContainer());
        try {
            Graphene.waitGui().withTimeout(1L, TimeUnit.SECONDS).until((Predicate)new Predicate<WebDriver>(){

                public boolean apply(WebDriver input) {
                    return RichFacesFileUpload.this.advanced().getFileInputElements().size() == expectedSize;
                }
            });
        }
        catch (TimeoutException ignored) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public AdvancedFileUploadInteractions advanced() {
        return this.interactions;
    }

    @Override
    public FileUpload clearAll() {
        this.advanced().getClearAllButtonElement().click();
        Graphene.waitGui().until((Predicate)new Predicate<WebDriver>(){

            public boolean apply(WebDriver input) {
                return RichFacesFileUpload.this.advanced().getItems().isEmpty();
            }
        });
        return this;
    }

    @Override
    public FileUpload upload() {
        this.advanced().getUploadButtonElement().click();
        return this;
    }

    public class AdvancedFileUploadInteractions
    implements VisibleComponentInteractions {
        private static final String DEFAULT_DONE_LABEL = "Done";
        private String doneLabel;

        public WebElement getRootElement() {
            return RichFacesFileUpload.this.rootElement;
        }

        public WebElement getAddButtonElement() {
            return RichFacesFileUpload.this.addButtonElement;
        }

        public WebElement getDisabledAddButtonElement() {
            return RichFacesFileUpload.this.disabledAddButtonElement;
        }

        public WebElement getClearAllButtonElement() {
            return RichFacesFileUpload.this.clearAllButtonElement;
        }

        public WebElement getFileInputElement() {
            return RichFacesFileUpload.this.fileInputElement;
        }

        protected List<WebElement> getFileInputElements() {
            return RichFacesFileUpload.this.fileInputElements;
        }

        protected WebElement getInputContainer() {
            return RichFacesFileUpload.this.inputContainer;
        }

        public WebElement getUploadButtonElement() {
            return RichFacesFileUpload.this.uploadButtonElement;
        }

        public String getDoneLabel() {
            return (String)Optional.fromNullable((Object)this.doneLabel).or((Object)DEFAULT_DONE_LABEL);
        }

        public ListComponent<? extends FileUploadItem> getItems() {
            return RichFacesFileUpload.this.items;
        }

        public void removeFile(int index) {
            this.removeFile(ChoicePickerHelper.byIndex().index(index));
        }

        public void removeFile(String match) {
            this.removeFile(ChoicePickerHelper.byVisibleText().match(match));
        }

        public void removeFile(ChoicePicker picker) {
            this.getItems().getItem(picker).remove();
        }

        public void setDoneLabel() {
            this.doneLabel = DEFAULT_DONE_LABEL;
        }

        public void setDoneLabel(String doneLabel) {
            this.doneLabel = doneLabel;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }

    public static class RichFacesFileUploadList
    extends AbstractListComponent<FileUploadItemImpl> {
    }

    public class FileUploadItemImpl
    extends RichFacesListItem
    implements FileUploadItem {
        @FindBy(className="rf-fu-itm-lbl")
        private WebElement filenameElement;
        @FindBy(className="rf-fu-itm-st")
        private WebElement stateElement;
        @FindBy(className="rf-fu-itm-lnk")
        private WebElement clearOrDeleteElement;

        @Override
        public WebElement getClearOrDeleteElement() {
            return this.clearOrDeleteElement;
        }

        @Override
        public String getFilename() {
            return this.filenameElement.getText();
        }

        @Override
        public WebElement getFilenameElement() {
            return this.filenameElement;
        }

        @Override
        public String getState() {
            return this.stateElement.getText();
        }

        @Override
        public WebElement getStateElement() {
            return this.stateElement;
        }

        @Override
        public boolean isUploaded() {
            if (Utils.isVisible(this.stateElement) && this.getState().equals(RichFacesFileUpload.this.advanced().getDoneLabel())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public void remove() {
            this.clearOrDeleteElement.click();
        }
    }
}

