/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.joda.time.DateTime;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.Validate;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.list.AbstractListComponent;
import org.richfaces.fragment.list.ListItem;
import org.richfaces.fragment.orderingList.AbstractSelectableListItem;

public class DayPicker {
    @Root
    private WebElement root;
    @FindBy(css="tr[id$=WeekDay]")
    private GrapheneElement weekDaysBarElement;
    @FindBy(css="tr[id$=WeekDay] > td")
    private List<WebElement> weekDaysLabelsElements;
    @FindBy(css="tr[id*=WeekNum]")
    private List<CalendarWeek> weeks;
    @FindBy(css="td[id*=DayCell]:not(.rf-cal-boundary-day):not(.rf-cal-day-lbl)")
    private List<WebElement> monthDaysElements;
    @FindBy(css="td[id*=DayCell].rf-cal-sel")
    private GrapheneElement selectedDayElement;
    @FindBy(css="td[id*=DayCell].rf-cal-today")
    private GrapheneElement todayDayElement;
    private CalendarDaysImpl days;

    public List<? extends CalendarDay> getBoundaryDays() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        List items = this.getDays().getItems(ChoicePickerHelper.byWebElement().attribute("class").contains("rf-cal-boundary-day"));
        return items;
    }

    public CalendarDaysImpl getDays() {
        if (this.days == null) {
            this.days = (CalendarDaysImpl)Graphene.createPageFragment(CalendarDaysImpl.class, (WebElement)this.getRootElement());
        }
        return this.days;
    }

    public List<? extends CalendarDay> getMonthDays() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        List items = this.getDays().getItems(ChoicePickerHelper.byWebElement().attribute("class").contains("rf-cal-boundary-day").not().and().attribute("class").contains("rf-cal-day-lbl").not());
        return items;
    }

    public CalendarDay getSelectedDay() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        if (this.getSelectedDayElement().isPresent()) {
            return (CalendarDay)Graphene.createPageFragment(CalendarDayImpl.class, (WebElement)this.getSelectedDayElement());
        }
        return null;
    }

    public List<? extends CalendarDay> getSpecificDays(Integer ... weekDayPosition) {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        Preconditions.checkNotNull((Object)weekDayPosition);
        for (Integer integer : weekDayPosition) {
            Preconditions.checkArgument((integer > 0 && integer < 8 ? 1 : 0) != 0);
        }
        ChoicePickerHelper.ByIndexChoicePicker indexPicker = ChoicePickerHelper.byIndex();
        for (Integer integer : weekDayPosition) {
            indexPicker.everyNth(7, integer - 1);
        }
        return this.getDays().getItems(indexPicker);
    }

    public CalendarDay getTodayDay() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        if (this.getTodayDayElement().isPresent()) {
            return (CalendarDay)Graphene.createPageFragment(CalendarDayImpl.class, (WebElement)this.getTodayDayElement());
        }
        return null;
    }

    public CalendarWeek getWeek(int weekFromActCalendar) {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        Validate.isTrue(weekFromActCalendar > 0 && weekFromActCalendar < 7, "weekFromActCalendar needs to be an integer between 0 and 7", new Object[0]);
        return this.getWeeks().get(weekFromActCalendar - 1);
    }

    public List<String> getWeekDayShortNames() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        if (!this.getWeekDaysBarElement().isDisplayed()) {
            throw new RuntimeException("Week days bar is not visible");
        }
        ArrayList<String> result = new ArrayList<String>(8);
        for (WebElement label : this.getWeekDaysLabelsElements()) {
            result.add(label.getText().trim());
        }
        result.remove(0);
        return result;
    }

    public WebElement getWeekDaysBarElement() {
        return this.weekDaysBarElement;
    }

    public List<CalendarWeek> getWeeks() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        return Collections.unmodifiableList(this.weeks);
    }

    public List<Integer> getWeeksNumbers() {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        ArrayList<Integer> result = new ArrayList<Integer>(6);
        for (CalendarWeek week : this.getWeeks()) {
            result.add(week.getWeekNumber());
        }
        return result;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.getRootElement());
    }

    public WebElement getRootElement() {
        return this.root;
    }

    public void selectDayInMonth(DateTime dateTime) {
        this.selectDayInMonth(dateTime.getDayOfMonth());
    }

    public void selectDayInMonth(int day) {
        if (!this.isVisible()) {
            throw new RuntimeException("Cannot interact with DayPicker.");
        }
        Validate.isTrue(day > 0 && day < 32, "day needs to be an integer between 0 and 32", new Object[0]);
        Validate.isTrue(this.getMonthDaysElements().size() >= day, "given month has less days (%s) then provided day (%s)", this.getMonthDaysElements().size(), day);
        String jq = "td[id*=DayCell]:not('.rf-cal-boundary-day'):not('.rf-cal-day-lbl'):contains('" + day + "')";
        ((CalendarDayImpl)Graphene.createPageFragment(CalendarDayImpl.class, (WebElement)this.getRootElement().findElement((By)ByJQuery.selector((String)jq)))).select();
    }

    public WaitingWrapper waitUntilIsNotVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                ((IsElementBuilder)wait.until().element(DayPicker.this.getRootElement()).is().not()).visible();
            }
        }.withMessage("Day picker to be not visible.");
    }

    public WaitingWrapper waitUntilIsVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.until().element(DayPicker.this.getRootElement()).is().visible();
            }
        }.withMessage("Day picker to be visible.");
    }

    public List<WebElement> getWeekDaysLabelsElements() {
        return this.weekDaysLabelsElements;
    }

    public List<WebElement> getMonthDaysElements() {
        return this.monthDaysElements;
    }

    public GrapheneElement getSelectedDayElement() {
        return this.selectedDayElement;
    }

    public GrapheneElement getTodayDayElement() {
        return this.todayDayElement;
    }

    public static class CalendarWeek {
        @FindBy(css="td[id*=WeekNumCell]")
        private WebElement weekNumberElement;
        @FindBy(css="td[id*=DayCell]")
        private List<CalendarDayImpl> days;

        public List<? extends CalendarDay> getCalendarDays() {
            return Collections.unmodifiableList(this.days);
        }

        public Integer getWeekNumber() {
            if (!this.weekNumberElement.isDisplayed()) {
                throw new RuntimeException("Week numbers are not displayed");
            }
            return Integer.parseInt(this.getWeekNumberElement().getText());
        }

        public WebElement getWeekNumberElement() {
            return this.weekNumberElement;
        }
    }

    public static class CalendarDaysImpl
    extends AbstractListComponent<CalendarDayImpl> {
        @FindByJQuery(value="td[id*='DayCell']:not(td[id*='WeekDayCell'])")
        private List<WebElement> items;

        @Override
        protected List<WebElement> getItemsElements() {
            return Collections.unmodifiableList(this.items);
        }
    }

    public static class CalendarDayImpl
    extends AbstractSelectableListItem
    implements CalendarDay,
    ListItem {
        @Override
        public boolean containsStyleClass(String styleClass) {
            return CalendarDay.DayType.check((WebElement)this.getRootElement(), styleClass);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CalendarDayImpl other = (CalendarDayImpl)obj;
            return this.getDayElement().equals(other.getDayElement());
        }

        @Override
        public WebElement getDayElement() {
            return this.getRootElement();
        }

        @Override
        public Integer getDayNumber() {
            return Integer.parseInt(this.getRootElement().getText().trim());
        }

        @Override
        protected String getStyleClassForSelectedItem() {
            return CalendarDay.DayType.selectedDay.getStyle();
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + (this.getRootElement() != null ? this.getRootElement().hashCode() : 0);
            return hash;
        }

        @Override
        public boolean is(CalendarDay.DayType type) {
            return type.isType((WebElement)this.getRootElement());
        }

        @Override
        public void select(boolean deselectOthers) {
            this.getRootElement().click();
            Graphene.waitGui().until().element((WebElement)this.getRootElement()).attribute("class").contains(this.getStyleClassForSelectedItem());
        }
    }

    public static interface CalendarDay {
        public Integer getDayNumber();

        public WebElement getDayElement();

        public boolean containsStyleClass(String var1);

        public boolean is(DayType var1);

        public void select();

        public static enum DayType {
            boundaryDay("rf-cal-boundary-day"),
            holidayDay("rf-cal-holiday"),
            selectableDay("rf-cal-btn"),
            selectedDay("rf-cal-sel"),
            todayDay("rf-cal-today"),
            weekendDay("rf-cal-holiday");

            private final String styleClass;

            private DayType(String styleClass) {
                this.styleClass = styleClass;
            }

            public boolean isType(WebElement day) {
                return DayType.check(day, this.styleClass);
            }

            public String getStyle() {
                return this.styleClass;
            }

            public static boolean check(WebElement day, String styleClass) {
                String attribute = day.getAttribute("class");
                if (attribute == null) {
                    return false;
                }
                return attribute.contains(styleClass);
            }
        }
    }
}

