/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.dataGrid;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.TypeResolver;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.dataGrid.DataGrid;

public class RichFacesDataGrid<RECORD>
implements DataGrid<RECORD>,
AdvancedVisibleComponentIteractions<AdvancedDataGridInteractions> {
    @Root
    private WebElement root;
    @FindBy(css=".rf-dg-r")
    private List<WebElement> rowElements;
    @FindByJQuery(value=".rf-dg-c:not(:empty)")
    private List<WebElement> recordsElements;
    @FindBy(css=".rf-dg-nd")
    private WebElement noDataElement;
    private final Class<RECORD> recordClass = TypeResolver.resolveRawArguments(DataGrid.class, this.getClass())[0];
    private final AdvancedDataGridInteractions advancedInteractions = new AdvancedDataGridInteractions();

    @Override
    public List<RECORD> getRecordsInRow(int rowIndex) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.getNumberOfRows() - 1 > rowIndex) {
            throw new IllegalArgumentException("There is not so many rows! Requesting: " + rowIndex + ", but there is only: " + this.getNumberOfRows());
        }
        List recordsInParticularRow = this.advanced().getRowElements().get(rowIndex).findElements((By)ByJQuery.selector((String)this.advanced().getJQSelectorForRecord()));
        for (WebElement recordRoot : recordsInParticularRow) {
            result.add(Graphene.createPageFragment(this.getRecordClass(), (WebElement)recordRoot));
        }
        return result;
    }

    @Override
    public RECORD getRecord(int n) {
        return (RECORD)Graphene.createPageFragment(this.getRecordClass(), (WebElement)this.advanced().getRecordsElements().get(n));
    }

    @Override
    public int getNumberOfRows() {
        return this.advanced().getRowElements().size();
    }

    @Override
    public int getNumberOfColumns() {
        if (this.advanced().getRowElements().isEmpty()) {
            return 0;
        }
        return this.advanced().getRowElements().get(0).findElements((By)ByJQuery.selector((String)this.advanced().getJQSelectorForColumn())).size();
    }

    @Override
    public int getNumberOfRecords() {
        return this.advanced().getRecordsElements().size();
    }

    @Override
    public List<RECORD> getAllVisibleRecords() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (WebElement recordRoot : this.advanced().getRecordsElements()) {
            result.add(Graphene.createPageFragment(this.getRecordClass(), (WebElement)recordRoot));
        }
        return result;
    }

    @Override
    public AdvancedDataGridInteractions advanced() {
        return this.advancedInteractions;
    }

    protected Class<RECORD> getRecordClass() {
        return this.recordClass;
    }

    public class AdvancedDataGridInteractions
    implements VisibleComponentInteractions {
        private static final String CSS_SEL_ROW = ".rf-dg-r";
        private static final String JQUERY_SEL_RECORD = ".rf-dg-c:not(:empty)";
        private static final String JQUERY_SEL_COLUMN = ".rf-dg-c";

        protected String getCssSelectorForRow() {
            return CSS_SEL_ROW;
        }

        protected String getJQSelectorForRecord() {
            return JQUERY_SEL_RECORD;
        }

        protected String getJQSelectorForColumn() {
            return JQUERY_SEL_COLUMN;
        }

        public WebElement getRootElement() {
            return RichFacesDataGrid.this.root;
        }

        protected List<WebElement> getRowElements() {
            return RichFacesDataGrid.this.rowElements;
        }

        protected List<WebElement> getRecordsElements() {
            return RichFacesDataGrid.this.recordsElements;
        }

        protected WebElement getNoDataElement() {
            return RichFacesDataGrid.this.noDataElement;
        }

        public boolean isNoData() {
            return Utils.isVisible(this.getNoDataElement());
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }
}

