/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.log;

import com.google.common.base.Predicate;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.fragment.Root;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.list.AbstractListComponent;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.list.RichFacesListItem;
import org.richfaces.fragment.log.Log;
import org.richfaces.fragment.log.LogEntry;

public class RichFacesLog
implements Log,
AdvancedVisibleComponentIteractions<AdvancedLogInteractions> {
    @Root
    private GrapheneElement root;
    @FindBy(css="div.rf-log-contents")
    private RichFacesLogEntries logEntries;
    @FindBy(tagName="button")
    private GrapheneElement clearButton;
    @FindBy(tagName="select")
    private Select levelSelect;
    private final AdvancedLogInteractions interactions = new AdvancedLogInteractions();

    @Override
    public AdvancedLogInteractions advanced() {
        return this.interactions;
    }

    @Override
    public void clear() {
        this.advanced().getClearButtonElement().click();
        Graphene.waitGui().until((Predicate)new Predicate<WebDriver>(){

            public boolean apply(WebDriver input) {
                return RichFacesLog.this.getLogEntries().isEmpty();
            }
        });
    }

    @Override
    public void changeLevel(Log.LogEntryLevel level) {
        this.advanced().getLevelSelectElement().selectByVisibleText(level.toString().toLowerCase());
    }

    @Override
    public ListComponent<? extends LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public class AdvancedLogInteractions
    implements VisibleComponentInteractions {
        public GrapheneElement getRootElement() {
            return RichFacesLog.this.root;
        }

        public GrapheneElement getClearButtonElement() {
            return RichFacesLog.this.clearButton;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible((WebElement)this.getRootElement());
        }

        protected Select getLevelSelectElement() {
            return RichFacesLog.this.levelSelect;
        }
    }

    private static enum RichFacesLogEntryLevel {
        DEBUG(Log.LogEntryLevel.DEBUG, "rf-log-entry-lbl-debug"),
        INFO(Log.LogEntryLevel.INFO, "rf-log-entry-lbl-info"),
        WARN(Log.LogEntryLevel.WARN, "rf-log-entry-lbl-warn"),
        ERROR(Log.LogEntryLevel.ERROR, "rf-log-entry-lbl-error");

        private final Log.LogEntryLevel level;
        private final String containsClass;

        private RichFacesLogEntryLevel(Log.LogEntryLevel level, String containsClass) {
            this.level = level;
            this.containsClass = containsClass;
        }

        private static Log.LogEntryLevel getLevelFromLabel(WebElement label) {
            String styleClasses = label.getAttribute("class");
            for (RichFacesLogEntryLevel logEntryLevel : RichFacesLogEntryLevel.values()) {
                if (!styleClasses.contains(logEntryLevel.containsClass)) continue;
                return logEntryLevel.level;
            }
            throw new RuntimeException("Cannot obtain level from label: " + label);
        }
    }

    public static class RichFacesLogEntry
    extends RichFacesListItem
    implements LogEntry {
        @FindBy(css="span.rf-log-entry-lbl")
        private WebElement labelElement;
        @FindBy(css="span.rf-log-entry-msg")
        private WebElement messageElement;

        @Override
        public String getContent() {
            return this.getMessageElement().getText();
        }

        @Override
        public Log.LogEntryLevel getLevel() {
            return RichFacesLogEntryLevel.getLevelFromLabel(this.getLabelElement());
        }

        @Override
        public DateTime getTimeStamp() {
            DateTime dt = null;
            String text = this.getLabelElement().getText();
            String timeStamp = text.substring(text.indexOf(91) + 1, text.indexOf(93));
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"HH:m:s.S");
            try {
                dt = formatter.parseDateTime(timeStamp);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Something went wrong with parsing of log entry timestamp!", e);
            }
            return dt;
        }

        protected WebElement getLabelElement() {
            return this.labelElement;
        }

        protected WebElement getMessageElement() {
            return this.messageElement;
        }
    }

    public static class RichFacesLogEntries
    extends AbstractListComponent<RichFacesLogEntry> {
    }
}

