/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.accordion;

import org.jboss.arquillian.graphene.GrapheneElement;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.switchable.AbstractComponentContainer;

public class RichFacesAccordionItem
extends AbstractComponentContainer
implements AdvancedInteractions<AdvancedAccordionItemInteractions> {
    @FindBy(className="rf-ac-itm-lbl-act")
    private GrapheneElement activeHeader;
    @FindBy(className="rf-ac-itm-lbl-dis")
    private GrapheneElement disabledHeader;
    @FindBy(className="rf-ac-itm-lbl-inact")
    private GrapheneElement inactiveHeader;
    @FindBy(className="rf-ac-itm-cnt")
    private GrapheneElement content;
    @FindBy(className="rf-ac-itm-hdr")
    private GrapheneElement toActivate;
    private final AdvancedAccordionItemInteractions advancedInteractions = new AdvancedAccordionItemInteractions();

    @Override
    public AdvancedAccordionItemInteractions advanced() {
        return this.advancedInteractions;
    }

    public class AdvancedAccordionItemInteractions {
        public String getHeader() {
            if (this.isActive()) {
                return this.getActiveHeaderElement().getText();
            }
            if (this.isEnabled()) {
                return this.getInactiveHeaderElement().getText();
            }
            return this.getDisabledHeaderElement().getText();
        }

        public WebElement getHeaderElement() {
            if (this.isActive()) {
                return this.getActiveHeaderElement();
            }
            if (this.isEnabled()) {
                return this.getInactiveHeaderElement();
            }
            return this.getDisabledHeaderElement();
        }

        public boolean isActive() {
            return this.getActiveHeaderElement().isPresent() && this.getActiveHeaderElement().isDisplayed() && this.getContentElement().isDisplayed();
        }

        public boolean isEnabled() {
            return !this.getDisabledHeaderElement().isPresent();
        }

        public WebElement getContentElement() {
            return RichFacesAccordionItem.this.content;
        }

        public WebElement getToActivateElement() {
            return RichFacesAccordionItem.this.toActivate;
        }

        protected GrapheneElement getActiveHeaderElement() {
            return RichFacesAccordionItem.this.activeHeader;
        }

        protected GrapheneElement getDisabledHeaderElement() {
            return RichFacesAccordionItem.this.disabledHeader;
        }

        protected WebElement getInactiveHeaderElement() {
            return RichFacesAccordionItem.this.inactiveHeader;
        }
    }
}

