/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.calendar.TimeEditor;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;

public abstract class TimeSpinner<T> {
    @Root
    private WebElement root;
    @FindBy(css="input.rf-cal-sp-inp")
    private TextInputComponentImpl input;
    @FindBy(className="rf-cal-sp-up")
    private WebElement buttonUpElement;
    @FindBy(className="rf-cal-sp-down")
    private WebElement buttonDownElement;

    public WebElement getButtonDownElement() {
        return this.buttonDownElement;
    }

    public WebElement getButtonUpElement() {
        return this.buttonUpElement;
    }

    public TextInputComponentImpl getInput() {
        return this.input;
    }

    public abstract T getValue();

    protected boolean isSameValueAreadySet(T value) {
        return this.getValue().equals(value);
    }

    public boolean isVisible() {
        return Utils.isVisible(this.getRootElement());
    }

    public void setValueBy(T value, TimeEditor.SetValueBy by) {
        switch (by) {
            case BUTTONS: {
                this.setValueByButtons(value);
                break;
            }
            case TYPING: {
                this.setValueByTyping(value);
                break;
            }
            default: {
                throw new RuntimeException("Unknown switch.");
            }
        }
    }

    public abstract void setValueByButtons(T var1);

    public void setValueByTyping(T value) {
        if (!this.isSameValueAreadySet(value)) {
            this.getInput().clear().sendKeys(value.toString());
        }
    }

    public void waitUntilIsVisible() {
        Graphene.waitModel().withMessage("Time spinner should be visible.").until().element(this.getRootElement()).is().visible();
    }

    protected WebElement getRootElement() {
        return this.root;
    }

    public static enum TimeSign {
        AM,
        PM;

    }

    public static class TimeSignSpinner
    extends TimeSpinner<TimeSign> {
        @Override
        public TimeSign getValue() {
            return TimeSign.valueOf(this.getInput().getStringValue().toUpperCase());
        }

        @Override
        public void setValueByButtons(TimeSign value) {
            if (!this.isSameValueAreadySet(value)) {
                this.getButtonDownElement().click();
                if (!this.getValue().equals((Object)value)) {
                    throw new RuntimeException("The time sign spinner should contain only 2 values: am, pm");
                }
            }
        }
    }

    public static class TimeSpinner24
    extends TimeSpinner60 {
        public TimeSpinner24() {
            super(24);
        }
    }

    public static class TimeSpinner12
    extends TimeSpinner60 {
        public TimeSpinner12() {
            super(12);
        }
    }

    public static class TimeSpinner60
    extends TimeSpinner<Integer> {
        private final int maxValue;

        public TimeSpinner60() {
            this(60);
        }

        public TimeSpinner60(int maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public Integer getValue() {
            return this.getInput().getIntValue();
        }

        @Override
        public void setValueByButtons(Integer value) {
            if (!this.isSameValueAreadySet(value)) {
                int actual = this.getValue();
                int difference = actual - value;
                int optimizedDifference = difference < 0 ? this.maxValue + difference : difference - this.maxValue;
                int n = optimizedDifference = Math.abs(optimizedDifference) > Math.abs(difference) ? difference : optimizedDifference;
                if (optimizedDifference < 0) {
                    this.clickUp(optimizedDifference);
                } else if (optimizedDifference > 0) {
                    this.clickDown(optimizedDifference);
                }
            }
        }

        private void clickUp(int times) {
            for (int i = 0; i > times; --i) {
                this.getButtonUpElement().click();
            }
        }

        private void clickDown(int times) {
            for (int i = 0; i < times; ++i) {
                this.getButtonDownElement().click();
            }
        }
    }
}

