/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.messages;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.GrapheneElementImpl;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.list.AbstractListComponent;
import org.richfaces.fragment.list.ListItem;
import org.richfaces.fragment.message.AbstractMessage;
import org.richfaces.fragment.message.Message;
import org.richfaces.fragment.messages.Messages;

public class RichFacesMessages
extends AbstractListComponent<MessageImpl>
implements Messages<MessageImpl>,
AdvancedInteractions<Messages.AdvancedMessagesInteractions> {
    @FindBy(css="span.rf-msgs-err")
    private List<MessageImpl> errorMessages;
    @FindBy(css="span.rf-msgs-ftl")
    private List<MessageImpl> fatalMessages;
    @FindBy(css="span.rf-msgs-inf")
    private List<MessageImpl> infoMessages;
    @FindBy(css="span.rf-msgs-ok")
    private List<MessageImpl> okMessages;
    @FindBy(css="span.rf-msgs-wrn")
    private List<MessageImpl> warnMessages;
    private final AdvancedMessagesInteractionsImpl interactions = new AdvancedMessagesInteractionsImpl();

    @Override
    public AdvancedMessagesInteractionsImpl advanced() {
        return this.interactions;
    }

    @Override
    public List<? extends Message> getItems(Message.MessageType type) {
        switch (type) {
            case OK: {
                return this.advanced().getOkMessages();
            }
            case INFORMATION: {
                return this.advanced().getInfoMessages();
            }
            case WARNING: {
                return this.advanced().getWarnMessages();
            }
            case ERROR: {
                return this.advanced().getErrorMessages();
            }
            case FATAL: {
                return this.advanced().getFatalMessages();
            }
        }
        throw new UnsupportedOperationException("Unknown type " + (Object)((Object)type));
    }

    public class AdvancedMessagesInteractionsImpl
    implements Messages.AdvancedMessagesInteractions {
        public WebElement getRootElement() {
            return RichFacesMessages.this.getRootElement();
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement()) && !RichFacesMessages.this.getItems().isEmpty();
        }

        @Override
        public WaitingWrapper waitUntilMessagesAreNotVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AdvancedMessagesInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for message to be not visible.");
        }

        @Override
        public WaitingWrapper waitUntilMessagesAreVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedMessagesInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for message to be visible.");
        }

        public List<MessageImpl> getErrorMessages() {
            return Collections.unmodifiableList(RichFacesMessages.this.errorMessages);
        }

        public List<MessageImpl> getFatalMessages() {
            return Collections.unmodifiableList(RichFacesMessages.this.fatalMessages);
        }

        public List<MessageImpl> getInfoMessages() {
            return Collections.unmodifiableList(RichFacesMessages.this.infoMessages);
        }

        public List<MessageImpl> getOkMessages() {
            return Collections.unmodifiableList(RichFacesMessages.this.okMessages);
        }

        public List<MessageImpl> getWarnMessages() {
            return Collections.unmodifiableList(RichFacesMessages.this.warnMessages);
        }
    }

    public static class MessageImpl
    extends AbstractMessage
    implements Message,
    ListItem {
        @FindBy(className="rf-msgs-det")
        private WebElement messageDetailElement;
        @FindBy(className="rf-msgs-sum")
        private WebElement messageSummaryElement;
        private final AdvancedMessageInMessagesInteractions interactions = new AdvancedMessageInMessagesInteractions();

        @Override
        public Message.AdvancedMessageInteractions advanced() {
            return this.interactions;
        }

        @Override
        protected String getCssClass(Message.MessageType type) {
            return MessageImpl.getCssClassForMessageType(type);
        }

        public static String getCssClassForMessageType(Message.MessageType type) {
            switch (type) {
                case ERROR: {
                    return "rf-msgs-err";
                }
                case FATAL: {
                    return "rf-msgs-ftl";
                }
                case INFORMATION: {
                    return "rf-msgs-inf";
                }
                case OK: {
                    return "rf-msgs-ok";
                }
                case WARNING: {
                    return "rf-msgs-wrn";
                }
            }
            throw new UnsupportedOperationException("Unknown message type " + (Object)((Object)type));
        }

        @Override
        public String getText() {
            return this.advanced().getRootElement().getText();
        }

        @Override
        public GrapheneElement getRootElement() {
            return new GrapheneElementImpl(this.advanced().getRootElement());
        }

        public class AdvancedMessageInMessagesInteractions
        extends AbstractMessage.AdvancedMessageInteractionsImpl {
            public AdvancedMessageInMessagesInteractions() {
                super(MessageImpl.this);
            }

            @Override
            public WebElement getDetailElement() {
                return MessageImpl.this.messageDetailElement;
            }

            @Override
            public WebElement getSummaryElement() {
                return MessageImpl.this.messageSummaryElement;
            }
        }
    }
}

