/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.pickList;

import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.common.picker.MultipleChoicePicker;
import org.richfaces.fragment.list.AbstractListComponent;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.orderingList.AbstractOrderingList;
import org.richfaces.fragment.orderingList.AbstractSelectableListItem;
import org.richfaces.fragment.orderingList.OrderingList;
import org.richfaces.fragment.orderingList.SelectableListItem;
import org.richfaces.fragment.pickList.PickList;

public class RichFacesPickList
implements PickList,
AdvancedVisibleComponentIteractions<AdvancedPickListInteractions> {
    @Root
    private WebElement root;
    @Drone
    private WebDriver driver;
    @FindBy(className="rf-pick-add-all")
    private WebElement addAllButtonElement;
    @FindBy(className="rf-pick-add")
    private WebElement addButtonElement;
    @FindBy(className="rf-pick-rem-all")
    private WebElement removeAllButtonElement;
    @FindBy(className="rf-pick-rem")
    private WebElement removeButtonElement;
    @FindBy(css="[id$='SourceItems'] > .rf-pick-sel")
    private List<WebElement> selectedSourceListItems;
    @FindBy(css="[id$='SourceItems'] > *")
    private List<WebElement> sourceListItems;
    @FindBy(css="[id$='SourceItems']")
    private SelectableListImpl sourceList;
    @FindBy(css="[id$='Target']")
    private OrderingListInPickList targetList;
    @FindBy(className="rf-pick-lst-scrl")
    private WebElement contentAreaElement;
    @FindBy(className="rf-pick-src-cptn")
    private WebElement sourceCaptionElement;
    @FindBy(css="thead.rf-pick-lst-hdr > tr.rf-pick-hdr")
    private WebElement sourceHeaderElement;
    private final AdvancedPickListInteractions interactions = new AdvancedPickListInteractions();

    @Override
    public AdvancedPickListInteractions advanced() {
        return this.interactions;
    }

    private void clickAddAllButton() {
        this.advanced().getAddAllButtonElement().click();
    }

    private void clickAddButton() {
        this.advanced().getAddButtonElement().click();
    }

    private void clickRemoveAllButton() {
        this.advanced().getRemoveAllButtonElement().click();
    }

    private void clickRemoveButton() {
        this.advanced().getRemoveButtonElement().click();
    }

    @Override
    public PickList add(ChoicePicker picker) {
        this.selectAndAdd(picker);
        return this;
    }

    @Override
    public PickList add(String match) {
        return this.add(ChoicePickerHelper.byVisibleText().match(match));
    }

    @Override
    public PickList add(int index) {
        return this.add(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PickList addMultiple(MultipleChoicePicker picker) {
        this.selectAndAddMultiple(picker);
        return this;
    }

    @Override
    public PickList addAll() {
        this.clickAddAllButton();
        return this;
    }

    @Override
    public PickList remove(ChoicePicker picker) {
        this.selectAndRemove(picker);
        return this;
    }

    @Override
    public PickList remove(String match) {
        return this.remove(ChoicePickerHelper.byVisibleText().match(match));
    }

    @Override
    public PickList remove(int index) {
        return this.remove(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PickList removeMultiple(MultipleChoicePicker picker) {
        this.selectAndRemoveMultiple(picker);
        return this;
    }

    @Override
    public PickList removeAll() {
        this.clickRemoveAllButton();
        return this;
    }

    private void selectAndAdd(ChoicePicker picker) {
        this.unselectAll(this.advanced().getSelectedSourceListItemsElements());
        this.selectItem(picker.pick(this.advanced().getSourceListItemsElements()));
        this.clickAddButton();
    }

    private void selectAndAddMultiple(MultipleChoicePicker picker) {
        this.unselectAll(this.advanced().getSelectedSourceListItemsElements());
        for (WebElement item : picker.pickMultiple(this.advanced().getSourceListItemsElements())) {
            this.selectItem(item);
        }
        this.clickAddButton();
    }

    private void selectAndRemove(ChoicePicker picker) {
        this.unselectAll(this.advanced().getSelectedTargetListItemsElements());
        this.selectItem(picker.pick(this.advanced().getTargetListItemsElements()));
        this.clickRemoveButton();
    }

    private void selectAndRemoveMultiple(MultipleChoicePicker picker) {
        this.unselectAll(this.advanced().getSelectedTargetListItemsElements());
        for (WebElement item : picker.pickMultiple(this.advanced().getTargetListItemsElements())) {
            this.selectItem(item);
        }
        this.clickRemoveButton();
    }

    private void selectItem(final WebElement item) {
        new Actions(this.driver).keyDown(Keys.CONTROL).click(item).keyUp(Keys.CONTROL).addAction(new Action(){

            public void perform() {
                Graphene.waitGui().until().element(item).attribute("class").contains("rf-pick-sel");
            }
        }).perform();
    }

    protected void unselectAll(List<WebElement> list) {
        if (!list.isEmpty()) {
            new Actions(this.driver).click(list.get(0)).keyDown(Keys.CONTROL).click(list.get(0)).keyUp(Keys.CONTROL).perform();
            if (!list.isEmpty()) {
                throw new RuntimeException("The unselection was not successfull.");
            }
        }
    }

    public static class SelectableListImpl
    extends AbstractListComponent<SelectableListItemImpl> {
    }

    public class AdvancedPickListInteractions
    implements VisibleComponentInteractions {
        public WebElement getAddAllButtonElement() {
            return RichFacesPickList.this.addAllButtonElement;
        }

        public WebElement getAddButtonElement() {
            return RichFacesPickList.this.addButtonElement;
        }

        public WebElement getBottomButtonElement() {
            return this._getOrderTargetList().advanced().getBottomButtonElement();
        }

        public WebElement getSourceCaptionElement() {
            return RichFacesPickList.this.sourceCaptionElement;
        }

        public WebElement getTargetCaptionElement() {
            return this._getOrderTargetList().advanced().getCaptionElement();
        }

        public WebElement getDownButtonElement() {
            return this._getOrderTargetList().advanced().getDownButtonElement();
        }

        public WebElement getSourceHeaderElement() {
            return RichFacesPickList.this.sourceHeaderElement;
        }

        public WebElement getTargetHeaderElement() {
            return this._getOrderTargetList().advanced().getHeaderElement();
        }

        public WebElement getSourceListContentAreaElement() {
            return RichFacesPickList.this.contentAreaElement;
        }

        public WebElement getTargetListContentAreaElement() {
            return this._getOrderTargetList().advanced().getContentAreaElement();
        }

        public WebElement getRemoveAllButtonElement() {
            return RichFacesPickList.this.removeAllButtonElement;
        }

        public WebElement getRemoveButtonElement() {
            return RichFacesPickList.this.removeButtonElement;
        }

        public List<WebElement> getSelectedSourceListItemsElements() {
            return RichFacesPickList.this.selectedSourceListItems;
        }

        public List<WebElement> getSourceListItemsElements() {
            return RichFacesPickList.this.sourceListItems;
        }

        public List<WebElement> getSelectedTargetListItemsElements() {
            return this._getOrderTargetList().advanced().getSelectedItemsElements();
        }

        public List<WebElement> getTargetListItemsElements() {
            return this._getOrderTargetList().advanced().getItemsElements();
        }

        public WebElement getRootElement() {
            return RichFacesPickList.this.root;
        }

        public ListComponent<? extends SelectableListItem> getSourceList() {
            return RichFacesPickList.this.sourceList;
        }

        public ListComponent<? extends SelectableListItem> getTargetList() {
            return this._getOrderTargetList().advanced().getList();
        }

        public WebElement getTopButtonElement() {
            return this._getOrderTargetList().advanced().getTopButtonElement();
        }

        public WebElement getUpButtonElement() {
            return this._getOrderTargetList().advanced().getUpButtonElement();
        }

        protected OrderingListInPickList _getOrderTargetList() {
            return RichFacesPickList.this.targetList;
        }

        public OrderingList getOrderTargetList() {
            return this._getOrderTargetList();
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }

    public static class SelectableListItemImpl
    extends AbstractSelectableListItem {
        private static final String SELECTED_ITEM_CLASS = "rf-pick-sel";

        @Override
        protected String getStyleClassForSelectedItem() {
            return SELECTED_ITEM_CLASS;
        }
    }

    public static class OrderingListInPickList
    extends AbstractOrderingList {
        private static final String SELECTED_ITEM_CLASS = "rf-pick-sel";
        @FindBy(css="button.rf-ord-dn")
        private WebElement downButtonElement;
        @FindBy(css="button.rf-ord-up-tp")
        private WebElement topButtonElement;
        @FindBy(css="button.rf-ord-dn-bt")
        private WebElement bottomButtonElement;
        @FindBy(css="button.rf-ord-up")
        private WebElement upButtonElement;
        @FindBy(css="thead.rf-pick-lst-hdr > tr.rf-pick-hdr")
        private WebElement headerElement;
        @FindBy(className="rf-pick-tgt-cptn")
        private WebElement captionElement;
        @FindBy(className="rf-pick-opt")
        private List<WebElement> items;
        @FindBy(className="rf-pick-sel")
        private List<WebElement> selectedItems;
        @FindBy(className="rf-pick-lst-scrl")
        private WebElement contentAreaElement;
        @FindBy(css="[id$='TargetItems']")
        private SelectableListImpl list;
        private final AdvancedOrderingListInPickListInteractions interactions = new AdvancedOrderingListInPickListInteractions();

        @Override
        public AbstractOrderingList.AdvancedOrderingListInteractions advanced() {
            return this.interactions;
        }

        public class AdvancedOrderingListInPickListInteractions
        extends AbstractOrderingList.AdvancedOrderingListInteractions {
            @Override
            public WebElement getBottomButtonElement() {
                return OrderingListInPickList.this.bottomButtonElement;
            }

            @Override
            public WebElement getCaptionElement() {
                return OrderingListInPickList.this.captionElement;
            }

            @Override
            public WebElement getDownButtonElement() {
                return OrderingListInPickList.this.downButtonElement;
            }

            @Override
            public WebElement getHeaderElement() {
                return OrderingListInPickList.this.headerElement;
            }

            @Override
            public List<WebElement> getItemsElements() {
                return Collections.unmodifiableList(OrderingListInPickList.this.items);
            }

            @Override
            public ListComponent<? extends SelectableListItem> getList() {
                return OrderingListInPickList.this.list;
            }

            @Override
            public WebElement getContentAreaElement() {
                return OrderingListInPickList.this.contentAreaElement;
            }

            @Override
            public List<WebElement> getSelectedItemsElements() {
                return Collections.unmodifiableList(OrderingListInPickList.this.selectedItems);
            }

            @Override
            protected String getStyleForSelectedItem() {
                return OrderingListInPickList.SELECTED_ITEM_CLASS;
            }

            @Override
            public WebElement getTopButtonElement() {
                return OrderingListInPickList.this.topButtonElement;
            }

            @Override
            public WebElement getUpButtonElement() {
                return OrderingListInPickList.this.upButtonElement;
            }
        }
    }
}

