/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.accordion;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.accordion.Accordion;
import org.richfaces.fragment.accordion.RichFacesAccordionItem;
import org.richfaces.fragment.switchable.AbstractSwitchableComponent;

public class RichFacesAccordion
extends AbstractSwitchableComponent<RichFacesAccordionItem>
implements Accordion {
    @FindBy(className="rf-ac-itm-hdr")
    private List<WebElement> switcherControllerElements;
    @FindBy(className="rf-ac-itm")
    private List<RichFacesAccordionItem> accordionItems;
    @FindByJQuery(value=".rf-ac-itm-cnt:visible")
    private WebElement visibleContent;
    private final AdvancedAccordionInteractions advancedInteractions = new AdvancedAccordionInteractions();

    @Override
    public AdvancedAccordionInteractions advanced() {
        return this.advancedInteractions;
    }

    @Override
    public int getNumberOfAccordionItems() {
        return this.accordionItems.size();
    }

    @Override
    protected List<WebElement> getSwitcherControllerElements() {
        return this.switcherControllerElements;
    }

    @Override
    protected WebElement getRootOfContainerElement() {
        return this.visibleContent;
    }

    public class AdvancedAccordionInteractions
    extends AbstractSwitchableComponent.AdvancedSwitchableComponentInteractions {
        public AdvancedAccordionInteractions() {
            super(RichFacesAccordion.this);
        }

        public List<RichFacesAccordionItem> getAccordionItems() {
            return Collections.unmodifiableList(RichFacesAccordion.this.accordionItems);
        }

        public RichFacesAccordionItem getActiveItem() {
            for (RichFacesAccordionItem item : RichFacesAccordion.this.accordionItems) {
                if (!item.advanced().isActive()) continue;
                return item;
            }
            return null;
        }

        @Override
        protected Predicate<WebDriver> getConditionForContentSwitched(final String textToContain) {
            return new Predicate<WebDriver>(){

                public boolean apply(WebDriver input) {
                    return AdvancedAccordionInteractions.this.getActiveItem().getActiveHeaderElement().getText().contains(textToContain);
                }
            };
        }
    }
}

