/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.accordion;

import org.jboss.arquillian.graphene.GrapheneElement;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.switchable.AbstractComponentContainer;

public class RichFacesAccordionItem
extends AbstractComponentContainer
implements AdvancedInteractions<AdvancedAccordionItemInteractions> {
    private static final String ACTIVE_HEADER_CLASS = "rf-ac-itm-lbl-act";
    private static final String DISABLED_HEADER_CLASS = "rf-ac-itm-lbl-dis";
    private static final String INACTIVE_HEADER_CLASS = "rf-ac-itm-lbl-inact";
    private static final String CONTENT_CLASS = "rf-ac-itm-cnt";
    private static final String TO_ACTIVATE_CLASS = "rf-ac-itm-hdr";
    @FindBy(className="rf-ac-itm-lbl-act")
    private GrapheneElement activeHeader;
    @FindBy(className="rf-ac-itm-lbl-dis")
    private GrapheneElement disabledHeader;
    @FindBy(className="rf-ac-itm-lbl-inact")
    private GrapheneElement inactiveHeader;
    @FindBy(className="rf-ac-itm-cnt")
    private GrapheneElement content;
    @FindBy(className="rf-ac-itm-hdr")
    private GrapheneElement toActivate;
    private final AdvancedAccordionItemInteractions advancedInteractions = new AdvancedAccordionItemInteractions();

    @Override
    public AdvancedAccordionItemInteractions advanced() {
        return this.advancedInteractions;
    }

    protected final GrapheneElement getActiveHeaderElement() {
        return this.activeHeader;
    }

    protected final GrapheneElement getDisabledHeaderElement() {
        return this.disabledHeader;
    }

    protected final WebElement getInactiveHeaderElement() {
        return this.inactiveHeader;
    }

    public class AdvancedAccordionItemInteractions {
        public String getHeader() {
            if (this.isActive()) {
                return RichFacesAccordionItem.this.getActiveHeaderElement().getText();
            }
            if (this.isEnabled()) {
                return RichFacesAccordionItem.this.getInactiveHeaderElement().getText();
            }
            return RichFacesAccordionItem.this.getDisabledHeaderElement().getText();
        }

        public final WebElement getHeaderElement() {
            if (this.isActive()) {
                return RichFacesAccordionItem.this.getActiveHeaderElement();
            }
            if (this.isEnabled()) {
                return RichFacesAccordionItem.this.getInactiveHeaderElement();
            }
            return RichFacesAccordionItem.this.getDisabledHeaderElement();
        }

        public boolean isActive() {
            return RichFacesAccordionItem.this.getActiveHeaderElement().isPresent() && RichFacesAccordionItem.this.getActiveHeaderElement().isDisplayed() && this.getContentElement().isDisplayed();
        }

        public boolean isEnabled() {
            return !RichFacesAccordionItem.this.getDisabledHeaderElement().isPresent();
        }

        public final WebElement getContentElement() {
            return RichFacesAccordionItem.this.content;
        }

        public final WebElement getToActivateElement() {
            return RichFacesAccordionItem.this.toActivate;
        }
    }
}

