/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.fragment.Root;
import org.joda.time.DateTime;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.calendar.PopupCalendar;
import org.richfaces.fragment.common.Locations;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;

public class RichFacesAdvancedPopupCalendar {
    @Root
    private WebElement root;
    @FindBy(css="span[id$=Popup] > input[id$='InputDate']")
    private TextInputComponentImpl input;
    @FindBy(css="span[id$=Popup] > .rf-cal-btn")
    private GrapheneElement popupButton;
    @FindBy(css="table[id$=Content]")
    private GrapheneElement popup;
    private PopupCalendar calendarPopup;

    public void closePopup() {
        this.closePopup(OpenedBy.OPEN_BUTTON_CLICKING);
    }

    public void closePopup(OpenedBy by) {
        if (this.getPopup().isVisible()) {
            switch (by) {
                case INPUT_CLICKING: {
                    this.input.advanced().getInputElement().click();
                    break;
                }
                case OPEN_BUTTON_CLICKING: {
                    this.popupButton.click();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.getPopup().waitUntilIsNotVisible().perform();
    }

    public TextInputComponentImpl getInput() {
        return this.input;
    }

    public Locations getLocations() {
        return Utils.getLocations(this.root);
    }

    public PopupCalendar getPopup() {
        if (this.calendarPopup == null) {
            this.calendarPopup = (PopupCalendar)Graphene.createPageFragment(PopupCalendar.class, (WebElement)this.root);
        }
        return this.calendarPopup;
    }

    public WebElement getPopupButtonElement() {
        return this.popupButton;
    }

    public WebElement getRootElement() {
        return this.root;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.root);
    }

    public PopupCalendar openPopup(OpenedBy by) {
        if (Utils.isVisible((WebElement)this.popup)) {
            return this.getPopup();
        }
        switch (by) {
            case INPUT_CLICKING: {
                if (!Utils.isVisible(this.input.advanced().getInputElement())) {
                    throw new RuntimeException("input is not displayed");
                }
                this.input.advanced().getInputElement().click();
                break;
            }
            case OPEN_BUTTON_CLICKING: {
                if (!this.popupButton.isDisplayed()) {
                    throw new RuntimeException("popup button is not displayed");
                }
                this.popupButton.click();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.getPopup().waitUntilIsVisible().perform();
        return this.getPopup();
    }

    public PopupCalendar openPopup() {
        return this.openPopup(OpenedBy.INPUT_CLICKING);
    }

    public void setDateTime(DateTime dt) {
        this.openPopup().setDateTime(dt);
    }

    public static enum OpenedBy {
        INPUT_CLICKING,
        OPEN_BUTTON_CLICKING;

    }
}

