/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.calendar;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.joda.time.DateTime;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.Validate;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;

public class YearAndMonthEditor {
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @FindByJQuery(value="div[id*='DateEditorLayoutM']:even")
    private List<WebElement> monthsEven;
    @FindByJQuery(value="div[id*='DateEditorLayoutM']:odd")
    private List<WebElement> monthsOdd;
    @FindBy(css="div[id*='DateEditorLayoutM'].rf-cal-edtr-btn-sel")
    private WebElement selectedMonth;
    @FindBy(css="div[id*='DateEditorLayoutY']")
    private List<WebElement> years;
    @FindByJQuery(value="div[id*='DateEditorLayoutY']:even")
    private List<WebElement> yearsEven;
    @FindByJQuery(value="div[id*='DateEditorLayoutY']:odd")
    private List<WebElement> yearsOdd;
    @FindBy(css="div[id*='DateEditorLayoutY0']")
    private WebElement firstYear;
    @FindBy(css="div[id*='DateEditorLayoutY'].rf-cal-edtr-btn-sel")
    private WebElement selectedYear;
    @FindByJQuery(value="[id$='DateEditorLayoutTR'] > td > div:eq(2)")
    private WebElement previousDecadeButtonElement;
    @FindByJQuery(value="[id$='DateEditorLayoutTR'] > td > div:eq(3)")
    private WebElement nextDecadeButtonElement;
    @FindBy(css="div[id$=DateEditorButtonOk]")
    private WebElement okButtonElement;
    @FindBy(css="div[id$=DateEditorButtonCancel]")
    private WebElement cancelButtonElement;
    private static final String SELECTED = "rf-cal-edtr-btn-sel";
    private long _timeoutForYearAndMonthEditorToBeNotVisible = -1L;
    private long _timeoutForYearAndMonthEditorToBeVisible = -1L;

    public void cancelDate() {
        this.cancelButtonElement.click();
        this.waitUntilIsNotVisible().perform();
    }

    public void confirmDate() {
        this.okButtonElement.click();
        this.waitUntilIsNotVisible().perform();
    }

    public WebElement getCancelButtonElement() {
        return this.cancelButtonElement;
    }

    public DateTime getDate() {
        return new DateTime().withMonthOfYear(this.getSelectedMonthNumber().intValue()).withYear(this.getSelectedYearNumber().intValue());
    }

    public List<Integer> getDisplayedYears() {
        ArrayList inRightOrder = Lists.newArrayList(this.yearsEven);
        inRightOrder.addAll(this.yearsOdd);
        ArrayList<Integer> result = new ArrayList<Integer>(10);
        for (WebElement webElement : inRightOrder) {
            result.add(Integer.parseInt(webElement.getText().trim()));
        }
        return result;
    }

    public WebElement getNextDecadeButtonElement() {
        return this.nextDecadeButtonElement;
    }

    public WebElement getOkButtonElement() {
        return this.okButtonElement;
    }

    public WebElement getPreviousDecadeButtonElement() {
        return this.previousDecadeButtonElement;
    }

    public WebElement getRoot() {
        return this.root;
    }

    public Integer getSelectedMonthNumber() {
        if (Utils.isVisible(this.selectedMonth)) {
            String id = this.selectedMonth.getAttribute("id");
            return Integer.parseInt(id.substring(id.lastIndexOf("M") + 1)) + 1;
        }
        return null;
    }

    public Integer getSelectedYearNumber() {
        if (Utils.isVisible(this.selectedYear)) {
            String year = this.selectedYear.getText();
            return Integer.parseInt(year);
        }
        return null;
    }

    public List<String> getShortMonthsLabels() {
        ArrayList inRightOrder = Lists.newArrayList(this.monthsEven);
        inRightOrder.addAll(this.monthsOdd);
        ArrayList<String> result = new ArrayList<String>(12);
        for (WebElement webElement : inRightOrder) {
            result.add(webElement.getText().trim());
        }
        return result;
    }

    public boolean isVisible() {
        return Utils.isVisible(this.root);
    }

    public void nextDecade() {
        String firstBefore = this.firstYear.getText();
        this.nextDecadeButtonElement.click();
        ((StringMatcher)Graphene.waitGui().withMessage("The decade was not changed.").until().element(this.firstYear).text().not()).equalTo(firstBefore);
    }

    public void previousDecade() {
        String firstBefore = this.firstYear.getText();
        this.previousDecadeButtonElement.click();
        ((StringMatcher)Graphene.waitGui().withMessage("The decade was not changed.").until().element(this.firstYear).text().not()).equalTo(firstBefore);
    }

    public YearAndMonthEditor selectDate(DateTime date) {
        return this.selectDate(date.getMonthOfYear(), date.getYear());
    }

    private YearAndMonthEditor selectDate(int month, int year) {
        Validate.isTrue(month > 0 && month < 13, "Month number has to be in interval <1,12>", new Object[0]);
        this.selectMonth(month);
        this.selectYear(year);
        return this;
    }

    private void selectMonth(int month) {
        WebElement monthElement = this.root.findElement(By.cssSelector((String)("div[id*='DateEditorLayoutM" + (month - 1) + "']")));
        monthElement.click();
        Graphene.waitGui().withMessage("The month was not selected.").until().element(monthElement).attribute("class").contains(SELECTED);
    }

    private void selectYear(int year) {
        int yearsPickerSize = this.years.size();
        int yearInTheFirstColumn = Integer.parseInt(this.firstYear.getText());
        int diff = year - yearInTheFirstColumn;
        if (diff > 0 && diff >= yearsPickerSize) {
            while (diff > 0) {
                this.nextDecade();
                diff -= yearsPickerSize;
            }
        } else {
            while (diff < 0) {
                this.previousDecade();
                diff += yearsPickerSize;
            }
        }
        WebElement yearElement = this.root.findElement((By)ByJQuery.selector((String)("div[id*='DateEditorLayoutY']:contains('" + year + "')")));
        yearElement.click();
        Graphene.waitGui().withMessage("The year was not selected.").until().element(yearElement).attribute("class").contains(SELECTED);
    }

    public void setuptimeoutForYearAndMonthEditorToBeNotVisible(long timeoutInMilliseconds) {
        this._timeoutForYearAndMonthEditorToBeNotVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForYearAndMonthEditorToBeNotVisible() {
        return this._timeoutForYearAndMonthEditorToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutForYearAndMonthEditorToBeNotVisible;
    }

    public void setupTimeoutForYearAndMonthEditorToBeVisible(long timeoutInMilliseconds) {
        this._timeoutForYearAndMonthEditorToBeVisible = timeoutInMilliseconds;
    }

    public long getTimeoutForYearAndMonthEditorToBeVisible() {
        return this._timeoutForYearAndMonthEditorToBeVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(this.browser) : this._timeoutForYearAndMonthEditorToBeVisible;
    }

    public WaitingWrapper waitUntilIsNotVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                ((IsElementBuilder)wait.until().element(YearAndMonthEditor.this.root).is().not()).visible();
            }
        }.withMessage("Year and month editor to be not visible.").withTimeout(this.getTimeoutForYearAndMonthEditorToBeNotVisible(), TimeUnit.MILLISECONDS);
    }

    public WaitingWrapper waitUntilIsVisible() {
        return new WaitingWrapperImpl(){

            @Override
            protected void performWait(FluentWait<WebDriver, Void> wait) {
                wait.until().element(YearAndMonthEditor.this.root).is().visible();
            }
        }.withMessage("Year and month editor to be not visible.").withTimeout(this.getTimeoutForYearAndMonthEditorToBeVisible(), TimeUnit.MILLISECONDS);
    }
}

