/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.inplaceSelect;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.condition.element.WebElementConditionFactory;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Event;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.inplaceInput.AbstractConfirmOrCancel;
import org.richfaces.fragment.inplaceInput.ConfirmOrCancel;
import org.richfaces.fragment.inplaceInput.InplaceComponentState;
import org.richfaces.fragment.inplaceSelect.InplaceSelect;

public class RichFacesInplaceSelect
implements InplaceSelect,
AdvancedInteractions<AdvancedInplaceSelectInteractions> {
    @FindBy(css="input[id$=Okbtn]")
    private WebElement confirmButton;
    @FindBy(css="input[id$=Cancelbtn]")
    private WebElement cancelButton;
    @FindBy(className="rf-is-fld")
    private TextInputComponentImpl textInput;
    @FindBy(className="rf-is-lbl")
    private WebElement label;
    @FindBy(css="span[id$=Edit] > input[id$=Input]")
    private WebElement editInputElement;
    @FindBy(className="rf-is-lst-cord")
    private WebElement localList;
    @FindBy(xpath="//body/span[contains(@class, rf-is-lst-cord)]")
    private WebElement globalList;
    private static final String OPTIONS_CLASS = "rf-is-opt";
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private JavascriptExecutor executor;
    private final AdvancedInplaceSelectInteractions advancedInteractions = new AdvancedInplaceSelectInteractions();

    @Override
    public AdvancedInplaceSelectInteractions advanced() {
        return this.advancedInteractions;
    }

    @Override
    public TextInputComponentImpl getTextInput() {
        return this.textInput;
    }

    @Override
    public ConfirmOrCancel select(ChoicePicker picker) {
        this.advanced().switchToEditingState();
        WebElement optionToBeSelected = picker.pick(this.advanced().getOptions());
        if (optionToBeSelected == null) {
            throw new IllegalArgumentException("There is no such option to be selected, which satisfied the given rules!");
        }
        optionToBeSelected.click();
        if (this.advanced().isSaveOnSelect() && !this.isShowControlls()) {
            this.textInput.advanced().trigger("blur");
            this.advanced().waitForPopupToHide().perform();
        }
        return new ConfirmOrCancelImpl();
    }

    @Override
    public ConfirmOrCancel select(int index) {
        return this.select(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public ConfirmOrCancel select(String text) {
        return this.select(ChoicePickerHelper.byVisibleText().match(text));
    }

    private boolean isShowControlls() {
        return (Boolean)new WebElementConditionFactory(this.cancelButton).isPresent().apply((Object)this.browser);
    }

    public class AdvancedInplaceSelectInteractions {
        private final Event DEFAULT_EDIT_EVENT;
        private Event editByEvent;
        private boolean saveOnSelect;
        private static final String RF_IS_CHNG_CLASS = "rf-is-chng";
        private static final String RF_IS_ACT_CLASS = "rf-is-act";
        private long _timeoutForPopupToHide;
        private long _timeoutForPopupToShow;

        public AdvancedInplaceSelectInteractions() {
            this.editByEvent = this.DEFAULT_EDIT_EVENT = Event.CLICK;
            this.saveOnSelect = false;
            this._timeoutForPopupToHide = -1L;
            this._timeoutForPopupToShow = -1L;
        }

        public void setupEditByEvent() {
            this.editByEvent = this.DEFAULT_EDIT_EVENT;
        }

        public void setupEditByEvent(Event event) {
            this.editByEvent = event;
        }

        public void setupSaveOnSelect(boolean saveOnSelect) {
            this.saveOnSelect = saveOnSelect;
        }

        public WebElement getRootElement() {
            return RichFacesInplaceSelect.this.root;
        }

        public void switchToEditingState() {
            Utils.triggerJQ(RichFacesInplaceSelect.this.executor, this.editByEvent.getEventName(), RichFacesInplaceSelect.this.root);
            this.waitForPopupToShow().perform();
        }

        public void setupTimeoutForPopupToHide(long timeoutInMilliseconds) {
            this._timeoutForPopupToHide = timeoutInMilliseconds;
        }

        public void setupTimeoutForPopupToShow(long timeoutInMilliseconds) {
            this._timeoutForPopupToShow = timeoutInMilliseconds;
        }

        public List<WebElement> getOptions() {
            return Collections.unmodifiableList(RichFacesInplaceSelect.this.browser.findElements(By.className((String)RichFacesInplaceSelect.OPTIONS_CLASS)));
        }

        public boolean isInState(InplaceComponentState state) {
            return RichFacesInplaceSelect.this.root.getAttribute("class").contains(this.getClassForState(state));
        }

        public String getClassForState(InplaceComponentState state) {
            switch (state) {
                case ACTIVE: {
                    return RF_IS_ACT_CLASS;
                }
                case CHANGED: {
                    return RF_IS_CHNG_CLASS;
                }
            }
            throw new UnsupportedOperationException();
        }

        public String getLabelValue() {
            return RichFacesInplaceSelect.this.label.getText().trim();
        }

        public WebElement getEditInputElement() {
            return RichFacesInplaceSelect.this.editInputElement;
        }

        public WebElement getLabelInputElement() {
            return RichFacesInplaceSelect.this.label;
        }

        public WebElement getCancelButtonElement() {
            return RichFacesInplaceSelect.this.cancelButton;
        }

        public WebElement getConfirmButtonElement() {
            return RichFacesInplaceSelect.this.confirmButton;
        }

        public WebElement getSelectedOption() {
            for (WebElement element : this.getOptions()) {
                if (!element.getAttribute("class").contains("rf-is-sel")) continue;
                return element;
            }
            return null;
        }

        public long getTimeoutForPopupToHide() {
            return this._timeoutForPopupToHide == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesInplaceSelect.this.browser) : this._timeoutForPopupToHide;
        }

        public long getTimeoutForPopupToShow() {
            return this._timeoutForPopupToShow == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesInplaceSelect.this.browser) : this._timeoutForPopupToShow;
        }

        public boolean isSaveOnSelect() {
            return this.saveOnSelect;
        }

        public WaitingWrapper waitForPopupToHide() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until().element(RichFacesInplaceSelect.this.localList).is().present();
                    ((IsElementBuilder)wait.until().element(RichFacesInplaceSelect.this.globalList).is().not()).visible();
                }
            }.withMessage("Waiting for popup to hide.").withTimeout(this.getTimeoutForPopupToHide(), TimeUnit.MILLISECONDS);
        }

        public WaitingWrapper waitForPopupToShow() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until().element(RichFacesInplaceSelect.this.globalList).is().visible();
                }
            }.withMessage("Waiting for popup to show.").withTimeout(this.getTimeoutForPopupToShow(), TimeUnit.MILLISECONDS);
        }
    }

    public class ConfirmOrCancelImpl
    extends AbstractConfirmOrCancel {
        @Override
        public WebDriver getBrowser() {
            return RichFacesInplaceSelect.this.browser;
        }

        @Override
        public WebElement getConfirmButton() {
            return RichFacesInplaceSelect.this.confirmButton;
        }

        @Override
        public WebElement getInput() {
            return RichFacesInplaceSelect.this.textInput.advanced().getInputElement();
        }

        @Override
        public WebElement getCancelButton() {
            return RichFacesInplaceSelect.this.cancelButton;
        }

        @Override
        public void waitAfterConfirmOrCancel() {
            RichFacesInplaceSelect.this.advanced().waitForPopupToHide().perform();
        }
    }
}

