/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.message;

import com.google.common.base.Predicate;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.message.Message;

public abstract class AbstractMessage
implements Message,
AdvancedInteractions<Message.AdvancedMessageInteractions> {
    @Root
    private GrapheneElement root;
    private final Message.AdvancedMessageInteractions interactions = new AdvancedMessageInteractionsImpl();

    @Override
    public Message.AdvancedMessageInteractions advanced() {
        return this.interactions;
    }

    protected abstract String getCssClass(Message.MessageType var1);

    @Override
    public String getDetail() {
        return this.getMessageDetailElement().getText();
    }

    protected abstract WebElement getMessageDetailElement();

    protected abstract WebElement getMessageSummaryElement();

    protected GrapheneElement getRootElement() {
        return this.root;
    }

    @Override
    public String getSummary() {
        return this.getMessageSummaryElement().getText();
    }

    @Override
    public Message.MessageType getType() {
        String attribute = this.getRootElement().getAttribute("class");
        for (Message.MessageType type : Message.MessageType.values()) {
            if (!attribute.contains(this.getCssClass(type))) continue;
            return type;
        }
        return null;
    }

    public class AdvancedMessageInteractionsImpl
    implements Message.AdvancedMessageInteractions {
        @Override
        public WebElement getDetailElement() {
            return AbstractMessage.this.getMessageDetailElement();
        }

        @Override
        public WebElement getRootElement() {
            return AbstractMessage.this.root;
        }

        @Override
        public WebElement getSummaryElement() {
            return AbstractMessage.this.getMessageSummaryElement();
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getSummaryElement()) || Utils.isVisible(this.getDetailElement());
        }

        @Override
        public WaitingWrapper waitUntilMessageIsNotVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AdvancedMessageInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for message to be not visible.");
        }

        @Override
        public WaitingWrapper waitUntilMessageIsVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedMessageInteractionsImpl.this.isVisible();
                        }
                    });
                }
            }.withMessage("Waiting for message to be visible.");
        }
    }
}

