/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.orderingList;

import java.util.List;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.common.picker.MultipleChoicePicker;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.orderingList.OrderingInteraction;
import org.richfaces.fragment.orderingList.OrderingList;
import org.richfaces.fragment.orderingList.PuttingSelectedItem;
import org.richfaces.fragment.orderingList.SelectableListItem;

public abstract class AbstractOrderingList
implements OrderingList,
AdvancedInteractions<AdvancedOrderingListInteractions> {
    @Root
    private WebElement root;
    private final OrderingInteraction orderingInteraction = new OrderingInteractionImpl();
    private final PuttingSelectedItem puttingSelectedItem = new PuttingSelectedItemImpl();

    protected WebElement getRoot() {
        return this.root;
    }

    @Override
    public PuttingSelectedItem select(String visibleText) {
        return this.select(ChoicePickerHelper.byVisibleText().match(visibleText));
    }

    @Override
    public PuttingSelectedItem select(Integer index) {
        return this.select(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PuttingSelectedItem select(ChoicePicker picker) {
        ((AdvancedOrderingListInteractions)this.advanced()).getList().getItem(picker).select(true);
        return this.puttingSelectedItem;
    }

    public abstract class AdvancedOrderingListInteractions {
        public abstract WebElement getBottomButtonElement();

        public abstract WebElement getCaptionElement();

        public abstract WebElement getDownButtonElement();

        public abstract WebElement getHeaderElement();

        public abstract List<WebElement> getItemsElements();

        public abstract ListComponent<? extends SelectableListItem> getList();

        public abstract WebElement getListAreaElement();

        public abstract WebElement getRootElement();

        public abstract WebElement getScrollBoxElement();

        public abstract List<WebElement> getSelectedItemsElements();

        public abstract WebElement getTopButtonElement();

        public abstract WebElement getUpButtonElement();

        public OrderingInteraction select(String visibleText, String ... otherTexts) {
            ChoicePickerHelper.ByVisibleTextChoicePicker picker = ChoicePickerHelper.byVisibleText().allRulesMustPass(false).match(visibleText);
            for (String string : otherTexts) {
                picker.match(string);
            }
            return this.select(picker);
        }

        public OrderingInteraction select(Integer index, Integer ... otherIndexes) {
            ChoicePickerHelper.ByIndexChoicePicker picker = ChoicePickerHelper.byIndex().index(index);
            for (Integer integer : otherIndexes) {
                picker.index(integer);
            }
            return this.select(picker);
        }

        public OrderingInteraction select(MultipleChoicePicker picker) {
            List<? extends SelectableListItem> items = ((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getList().getItems(picker);
            if (!items.isEmpty()) {
                items.get(0).select(true);
                for (int i = 1; i < items.size(); ++i) {
                    items.get(i).select();
                }
            }
            return AbstractOrderingList.this.orderingInteraction;
        }
    }

    private class OrderingInteractionImpl
    implements OrderingInteraction {
        private OrderingInteractionImpl() {
        }

        private void checkIfActionPosibleAndPerform(WebElement button, int times) {
            if (!button.isEnabled()) {
                throw new RuntimeException("No items are selected or button is disabled.");
            }
            for (int i = 0; i < times; ++i) {
                button.click();
            }
        }

        @Override
        public void bottom() {
            this.checkIfActionPosibleAndPerform(((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getBottomButtonElement(), 1);
        }

        @Override
        public void down(int times) {
            this.checkIfActionPosibleAndPerform(((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getDownButtonElement(), times);
        }

        @Override
        public void top() {
            this.checkIfActionPosibleAndPerform(((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getTopButtonElement(), 1);
        }

        @Override
        public void up(int times) {
            this.checkIfActionPosibleAndPerform(((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getUpButtonElement(), times);
        }
    }

    private class PuttingSelectedItemImpl
    implements PuttingSelectedItem {
        private PuttingSelectedItemImpl() {
        }

        private OrderingList putAction(int positionSource, int positionTarget, int differenceToEnd) {
            if (positionSource != positionTarget) {
                int differenceBetween = positionTarget - positionSource;
                int absBetween = Math.abs(differenceBetween);
                int min = Math.min(absBetween, Math.min(positionTarget, differenceToEnd));
                if (min == absBetween) {
                    this.singleStepMove(differenceBetween);
                } else if (min == positionTarget) {
                    AbstractOrderingList.this.orderingInteraction.top();
                    if (positionTarget != 0) {
                        this.singleStepMove(positionTarget);
                    }
                } else {
                    AbstractOrderingList.this.orderingInteraction.bottom();
                    if (differenceToEnd != 0) {
                        this.singleStepMove(-differenceToEnd);
                    }
                }
            }
            return AbstractOrderingList.this;
        }

        @Override
        public OrderingList putItAfter(ChoicePicker picker) {
            int indexOfTargetItem = Utils.getIndexOfElement(picker.pick(((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getItemsElements())) + 1;
            return this.putAction(Utils.getIndexOfElement(((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getSelectedItemsElements().get(0)), indexOfTargetItem, ((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getItemsElements().size() - indexOfTargetItem);
        }

        @Override
        public OrderingList putItAfter(int index) {
            return this.putItAfter(ChoicePickerHelper.byIndex().index(index));
        }

        @Override
        public OrderingList putItAfter(String match) {
            return this.putItAfter(ChoicePickerHelper.byVisibleText().match(match));
        }

        @Override
        public OrderingList putItBefore(ChoicePicker picker) {
            int indexOfTargetItem = Utils.getIndexOfElement(picker.pick(((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getItemsElements()));
            return this.putAction(Utils.getIndexOfElement(((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getSelectedItemsElements().get(0)), indexOfTargetItem, ((AdvancedOrderingListInteractions)AbstractOrderingList.this.advanced()).getItemsElements().size() - indexOfTargetItem);
        }

        @Override
        public OrderingList putItBefore(int index) {
            return this.putItBefore(ChoicePickerHelper.byIndex().index(index));
        }

        @Override
        public OrderingList putItBefore(String match) {
            return this.putItBefore(ChoicePickerHelper.byVisibleText().match(match));
        }

        private void singleStepMove(int difference) {
            if (difference != 0) {
                if (difference > 0) {
                    AbstractOrderingList.this.orderingInteraction.down(Math.abs(difference));
                } else {
                    AbstractOrderingList.this.orderingInteraction.up(Math.abs(difference));
                }
            }
        }
    }
}

