/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.orderingList;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.list.RichFacesListItem;
import org.richfaces.fragment.orderingList.SelectableListItem;

public abstract class AbstractSelectableListItem
extends RichFacesListItem
implements SelectableListItem {
    @Drone
    private WebDriver driver;

    @Override
    public boolean isSelected() {
        return this.getRootElement().getAttribute("class").contains(this.getStyleClassForSelectedItem());
    }

    protected abstract String getStyleClassForSelectedItem();

    @Override
    public void select() {
        this.select(Boolean.FALSE);
    }

    @Override
    public void select(boolean deselectOthers) {
        if (deselectOthers) {
            this.getRootElement().click();
            Graphene.waitModel().until().element((WebElement)this.getRootElement()).attribute("class").contains(this.getStyleClassForSelectedItem());
        } else if (!this.isSelected()) {
            new Actions(this.driver).keyDown(Keys.CONTROL).click((WebElement)this.getRootElement()).keyUp(Keys.CONTROL).addAction(new Action(){

                public void perform() {
                    Graphene.waitModel().until().element((WebElement)AbstractSelectableListItem.this.getRootElement()).attribute("class").contains(AbstractSelectableListItem.this.getStyleClassForSelectedItem());
                }
            }).perform();
        }
    }

    @Override
    public void deselect() {
        if (this.isSelected()) {
            new Actions(this.driver).keyDown(Keys.CONTROL).click((WebElement)this.getRootElement()).keyUp(Keys.CONTROL).addAction(new Action(){

                public void perform() {
                    ((StringMatcher)Graphene.waitModel().until().element((WebElement)AbstractSelectableListItem.this.getRootElement()).attribute("class").not()).contains(AbstractSelectableListItem.this.getStyleClassForSelectedItem());
                }
            }).perform();
        }
    }
}

