/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.panel;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.TypeResolver;
import org.richfaces.fragment.panel.Panel;

public abstract class AbstractPanel<HEADER, BODY>
implements Panel<HEADER, BODY> {
    @Root
    private WebElement root;
    private final Class<BODY> bodyClass = TypeResolver.resolveRawArguments(Panel.class, this.getClass())[1];
    private final Class<HEADER> headerClass = TypeResolver.resolveRawArguments(Panel.class, this.getClass())[0];

    @Override
    public BODY getBodyContent() {
        return (BODY)Graphene.createPageFragment(this.bodyClass, (WebElement)this.getBodyElement());
    }

    protected abstract WebElement getBodyElement();

    @Override
    public HEADER getHeaderContent() {
        if (!this.getHeaderElement().isPresent()) {
            throw new IllegalStateException("You are trying to get header content of the panel which does not have header!");
        }
        return (HEADER)Graphene.createPageFragment(this.headerClass, (WebElement)this.getHeaderElement());
    }

    protected abstract GrapheneElement getHeaderElement();

    protected WebElement getRootElement() {
        return this.root;
    }
}

