/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.pickList;

import java.util.List;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.common.picker.MultipleChoicePicker;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.list.ListItem;
import org.richfaces.fragment.orderingList.OrderingList;
import org.richfaces.fragment.orderingList.RichFacesOrderingList;
import org.richfaces.fragment.orderingList.SelectableListItem;
import org.richfaces.fragment.pickList.PickList;

public class RichFacesPickList
implements PickList,
AdvancedInteractions<AdvancedPickListInteractions> {
    @Root
    private WebElement root;
    @FindBy(className="btn-add-all")
    private WebElement addAllButtonElement;
    @FindBy(className="btn-add")
    private WebElement addButtonElement;
    @FindBy(className="btn-remove-all")
    private WebElement removeAllButtonElement;
    @FindBy(className="btn-remove")
    private WebElement removeButtonElement;
    @FindBy(css=".source-wrapper .ui-sortable.ui-selectable")
    private RichFacesOrderingList.SelectableListImpl sourceList;
    @FindBy(css=".source")
    private WebElement listAreaElement;
    @FindBy(css=".source.header")
    private WebElement sourceCaptionElement;
    @FindBy(className="target-wrapper")
    private RichFacesOrderingList targetList;
    @FindBy(css=".target.header")
    private WebElement targetCaptionElement;
    @FindBy(tagName="thead")
    private WebElement headerElement;
    @FindByJQuery(value=".scroll-box:eq(0)")
    private WebElement scrollBoxWithSourceList;
    @FindBy(className="inner")
    private WebElement pickListInteractionPartElement;
    private static final String DISABLED_ITEM_CLASS = "ui-disabled";
    private static final String SELECTED_ITEM_CLASS = "ui-selected";
    private final AdvancedPickListInteractions interactions = new AdvancedPickListInteractions();

    @Override
    public AdvancedPickListInteractions advanced() {
        return this.interactions;
    }

    private void clickAddAllButton() {
        this.addAllButtonElement.click();
    }

    private void clickAddButton() {
        this.addButtonElement.click();
    }

    private void clickRemoveAllButton() {
        this.removeAllButtonElement.click();
    }

    private void clickRemoveButton() {
        this.removeButtonElement.click();
    }

    @Override
    public PickList add(ChoicePicker picker) {
        this.select(picker, (ListComponent<? extends SelectableListItem>)this.sourceList);
        this.clickAddButton();
        return this;
    }

    @Override
    public PickList add(String match) {
        return this.add(ChoicePickerHelper.byVisibleText().match(match));
    }

    @Override
    public PickList add(int index) {
        return this.add(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PickList addMultiple(MultipleChoicePicker picker) {
        this.select(picker, (ListComponent<? extends SelectableListItem>)this.sourceList);
        this.clickAddButton();
        return this;
    }

    @Override
    public PickList addAll() {
        this.clickAddAllButton();
        return this;
    }

    @Override
    public PickList remove(ChoicePicker picker) {
        this.select(picker, this.targetList.advanced().getList());
        this.clickRemoveButton();
        return this;
    }

    @Override
    public PickList remove(String match) {
        return this.remove(ChoicePickerHelper.byVisibleText().match(match));
    }

    @Override
    public PickList remove(int index) {
        return this.remove(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PickList removeMultiple(MultipleChoicePicker picker) {
        this.select(picker, this.targetList.advanced().getList());
        this.clickRemoveButton();
        return this;
    }

    @Override
    public PickList removeAll() {
        this.clickRemoveAllButton();
        return this;
    }

    private void select(ChoicePicker picker, ListComponent<? extends SelectableListItem> list) {
        list.getItem(picker).select(true);
    }

    private void select(MultipleChoicePicker picker, ListComponent<? extends SelectableListItem> list) {
        List<? extends SelectableListItem> items = list.getItems(picker);
        if (!items.isEmpty()) {
            items.get(0).select(true);
            for (int i = 1; i < items.size(); ++i) {
                items.get(i).select();
            }
        }
    }

    public class AdvancedPickListInteractions {
        public WebElement getPickListInteractionPartElement() {
            return RichFacesPickList.this.pickListInteractionPartElement;
        }

        public WebElement getAddAllButtonElement() {
            return RichFacesPickList.this.addAllButtonElement;
        }

        public WebElement getAddButtonElement() {
            return RichFacesPickList.this.addButtonElement;
        }

        public WebElement getBottomButtonElement() {
            return RichFacesPickList.this.targetList.advanced().getBottomButtonElement();
        }

        public WebElement getSourceCaptionElement() {
            return RichFacesPickList.this.sourceCaptionElement;
        }

        public WebElement getTargetCaptionElement() {
            return RichFacesPickList.this.targetCaptionElement;
        }

        public WebElement getDownButtonElement() {
            return RichFacesPickList.this.targetList.advanced().getDownButtonElement();
        }

        public WebElement getSourceHeaderElement() {
            return RichFacesPickList.this.headerElement;
        }

        public WebElement getTargetHeaderElement() {
            return RichFacesPickList.this.targetList.advanced().getHeaderElement();
        }

        public WebElement getSourceListAreaElement() {
            return RichFacesPickList.this.listAreaElement;
        }

        public WebElement getTargetListAreaElement() {
            return RichFacesPickList.this.targetList.advanced().getListAreaElement();
        }

        public WebElement getRemoveAllButtonElement() {
            return RichFacesPickList.this.removeAllButtonElement;
        }

        public WebElement getRemoveButtonElement() {
            return RichFacesPickList.this.removeButtonElement;
        }

        public WebElement getRootElement() {
            return RichFacesPickList.this.root;
        }

        public ListComponent<? extends SelectableListItem> getSourceList() {
            return RichFacesPickList.this.sourceList;
        }

        public ListComponent<? extends SelectableListItem> getTargetList() {
            return RichFacesPickList.this.targetList.advanced().getList();
        }

        public WebElement getTopButtonElement() {
            return RichFacesPickList.this.targetList.advanced().getTopButtonElement();
        }

        public WebElement getUpButtonElement() {
            return RichFacesPickList.this.targetList.advanced().getUpButtonElement();
        }

        public boolean isDisabled() {
            return this.areAllButtonsDisabled() && this.areAllGivenItemsDisabled(this.getSourceList().getItems()) && this.areAllGivenItemsDisabled(this.getTargetList().getItems());
        }

        public boolean isItemSelected(ListItem item) {
            String classAttr = item.getRootElement().getAttribute("class");
            return classAttr != null && classAttr.contains(RichFacesPickList.SELECTED_ITEM_CLASS);
        }

        public double getHeight() {
            return Double.valueOf(RichFacesPickList.this.scrollBoxWithSourceList.getCssValue("height").replace("px", ""));
        }

        public double getMaxHeight() {
            return Double.valueOf(RichFacesPickList.this.scrollBoxWithSourceList.getCssValue("max-height").replace("px", ""));
        }

        public double getMinHeight() {
            return Double.valueOf(RichFacesPickList.this.scrollBoxWithSourceList.getCssValue("min-height").replace("px", ""));
        }

        private boolean areAllGivenItemsDisabled(List<? extends SelectableListItem> items) {
            boolean result = true;
            for (SelectableListItem selectableListItem : items) {
                String classAttr = selectableListItem.getRootElement().getAttribute("class");
                if (classAttr != null && classAttr.contains(RichFacesPickList.DISABLED_ITEM_CLASS)) continue;
                result = false;
            }
            return result;
        }

        private boolean areAllButtonsDisabled() {
            boolean result = true;
            if (this.getAddAllButtonElement().isEnabled()) {
                result = false;
            } else if (this.getAddButtonElement().isEnabled()) {
                result = false;
            } else if (this.getRemoveAllButtonElement().isEnabled()) {
                result = false;
            } else if (this.getRemoveButtonElement().isEnabled()) {
                result = false;
            } else if (this.getUpButtonElement().isEnabled()) {
                result = false;
            } else if (this.getTopButtonElement().isEnabled()) {
                result = false;
            } else if (this.getDownButtonElement().isEnabled()) {
                result = false;
            } else if (this.getBottomButtonElement().isEnabled()) {
                result = false;
            }
            return result;
        }

        public OrderingList orderTargetList() {
            return RichFacesPickList.this.targetList;
        }
    }
}

