/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.tooltip;

import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Event;
import org.richfaces.fragment.common.TypeResolver;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.tooltip.Tooltip;

public abstract class RichFacesTooltip<CONTENT>
implements Tooltip<CONTENT>,
AdvancedInteractions<AdvancedTooltipInteractions> {
    @Root
    private WebElement root;
    @ArquillianResource
    private WebDriver driver;
    private final Class<CONTENT> contentClass = TypeResolver.resolveRawArguments(RichFacesTooltip.class, this.getClass())[0];
    private final AdvancedTooltipInteractions interactions = new AdvancedTooltipInteractions();

    @Override
    public AdvancedTooltipInteractions advanced() {
        return this.interactions;
    }

    @Override
    public CONTENT getContent() {
        return (CONTENT)Graphene.createPageFragment(this.contentClass, (WebElement)this.advanced().getTooltipElement());
    }

    @Override
    public RichFacesTooltip<CONTENT> hide() {
        this.advanced().initiateTooltipsBefore();
        new Actions(this.driver).triggerEventByWD(this.advanced().getHideEvent(), this.advanced().getTarget()).perform();
        this.advanced().waitUntilTooltipIsNotVisible().perform();
        return this;
    }

    @Override
    public RichFacesTooltip<CONTENT> hide(WebElement target) {
        this.advanced().setupTarget(target);
        return this.hide();
    }

    @Override
    public RichFacesTooltip<CONTENT> show() {
        this.advanced().initiateTooltipsBefore();
        new Actions(this.driver).moveToElement(this.advanced().getTarget()).triggerEventByWD(this.advanced().getShowEvent(), this.advanced().getTarget()).perform();
        this.advanced().waitUntilTooltipIsVisible().perform();
        this.advanced().acquireLastVisibleTooltipIDIfNotSet();
        return this;
    }

    @Override
    public RichFacesTooltip<CONTENT> show(WebElement target) {
        this.advanced().setupTarget(target);
        return this.show();
    }

    public class AdvancedTooltipInteractions {
        private final ByJQuery tooltipsSelector = ByJQuery.selector((String)".rf-tt:visible");
        private final Event DEFAULT_SHOW_EVENT;
        private Event showEvent = this.DEFAULT_SHOW_EVENT = Event.MOUSEOVER;
        private final Event DEFAULT_HIDE_EVENT;
        private Event hideEvent = this.DEFAULT_HIDE_EVENT = Event.MOUSEOUT;
        private WebElement target;
        private String idOfTooltip;
        private int tooltipsBefore;
        private long _timoutForTooltipToBeNotVisible = -1L;
        private long _timeoutForTooltipToBeVisible = -1L;

        protected void acquireLastVisibleTooltipIDIfNotSet() {
            if (this.idOfTooltip == null) {
                this.idOfTooltip = RichFacesTooltip.this.driver.findElement((By)ByJQuery.selector((String)".rf-tt:last:visible")).getAttribute("id");
            }
        }

        protected Event getHideEvent() {
            return this.hideEvent;
        }

        protected String getIdOfTooltip() {
            return this.idOfTooltip;
        }

        protected Event getShowEvent() {
            return this.showEvent;
        }

        protected WebElement getTarget() {
            if (this.target == null) {
                return RichFacesTooltip.this.root;
            }
            return this.target;
        }

        protected int getTooltipsBefore() {
            return this.tooltipsBefore;
        }

        public WebElement getTooltipElement() {
            if (this.getIdOfTooltip() == null) {
                throw new IllegalStateException("Cannot obtain tooltip element. You have to show it first.");
            }
            return RichFacesTooltip.this.driver.findElement(By.id((String)this.getIdOfTooltip()));
        }

        protected void initiateTooltipsBefore() {
            this.tooltipsBefore = RichFacesTooltip.this.driver.findElements((By)this.tooltipsSelector).size();
        }

        public void setupHideEvent() {
            this.hideEvent = this.DEFAULT_HIDE_EVENT;
        }

        public void setupHideEvent(Event event) {
            this.hideEvent = event;
        }

        public void setupShowEvent() {
            this.showEvent = this.DEFAULT_SHOW_EVENT;
        }

        public void setupShowEvent(Event event) {
            this.showEvent = event;
        }

        public void setupTarget() {
            this.target = null;
        }

        public void setupTarget(WebElement target) {
            this.target = target;
        }

        public WaitingWrapper waitUntilTooltipIsNotVisible() {
            return this.getIdOfTooltip() == null ? new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            if (AdvancedTooltipInteractions.this.getTooltipsBefore() == 0) {
                                return RichFacesTooltip.this.driver.findElements((By)AdvancedTooltipInteractions.this.tooltipsSelector).isEmpty();
                            }
                            return RichFacesTooltip.this.driver.findElements((By)AdvancedTooltipInteractions.this.tooltipsSelector).size() < AdvancedTooltipInteractions.this.getTooltipsBefore();
                        }
                    });
                }
            }.withTimeout(this.getTimoutForTooltipToBeNotVisible(), TimeUnit.MILLISECONDS).withMessage("Waiting until some tooltip disappears. There were " + this.getTooltipsBefore() + " tooltips before, now there are: " + RichFacesTooltip.this.driver.findElements((By)this.tooltipsSelector).size()) : new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    ((IsElementBuilder)wait.until().element((SearchContext)RichFacesTooltip.this.driver, By.id((String)AdvancedTooltipInteractions.this.getIdOfTooltip())).is().not()).visible();
                }
            }.withTimeout(this.getTimoutForTooltipToBeNotVisible(), TimeUnit.MILLISECONDS).withMessage("Waiting until tooltip is not visible.");
        }

        public WaitingWrapper waitUntilTooltipIsVisible() {
            return this.getIdOfTooltip() == null ? new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return RichFacesTooltip.this.driver.findElements((By)AdvancedTooltipInteractions.this.tooltipsSelector).size() > AdvancedTooltipInteractions.this.getTooltipsBefore();
                        }
                    });
                }
            }.withTimeout(this.getTimeoutForTooltipToBeVisible(), TimeUnit.MILLISECONDS).withMessage("Waiting until a new tooltip appears. There were " + this.getTooltipsBefore() + " tooltips before, now there are: " + RichFacesTooltip.this.driver.findElements((By)this.tooltipsSelector).size()) : new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until().element((SearchContext)RichFacesTooltip.this.driver, By.id((String)AdvancedTooltipInteractions.this.getIdOfTooltip())).is().visible();
                }
            }.withTimeout(this.getTimeoutForTooltipToBeVisible(), TimeUnit.MILLISECONDS).withMessage("Waiting until tooltip is visible.");
        }

        public void setupTimoutForTooltipToBeNotVisible(long timeoutInMilliseconds) {
            this._timoutForTooltipToBeNotVisible = timeoutInMilliseconds;
        }

        public long getTimoutForTooltipToBeNotVisible() {
            return this._timoutForTooltipToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesTooltip.this.driver) : this._timoutForTooltipToBeNotVisible;
        }

        public void setupTimeoutForTooltipToBeVisible(long timeoutInMilliseconds) {
            this._timeoutForTooltipToBeVisible = timeoutInMilliseconds;
        }

        public long getTimeoutForTooltipToBeVisible() {
            return this._timeoutForTooltipToBeVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesTooltip.this.driver) : this._timeoutForTooltipToBeVisible;
        }
    }
}

