/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.common;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.richfaces.fragment.common.ClearType;
import org.richfaces.fragment.common.TextInputComponent;
import org.richfaces.fragment.common.Utils;

public class TextInputComponentImpl
implements TextInputComponent {
    @Root
    private WebElement root;
    @ArquillianResource
    private JavascriptExecutor executor;
    @Drone
    private WebDriver driver;
    private final AdvancedTextInputInteractions advancedInteractions = new AdvancedTextInputInteractions();

    public AdvancedTextInputInteractions advanced() {
        return this.advancedInteractions;
    }

    @Override
    public TextInputComponent clear() {
        this.advanced().clear(ClearType.DEFAULT_CLEAR_TYPE);
        return this;
    }

    @Override
    public int getIntValue() {
        return Integer.valueOf(this.getStringValue());
    }

    @Override
    public String getStringValue() {
        return this.root.getAttribute("value");
    }

    @Override
    public TextInputComponentImpl sendKeys(CharSequence text) {
        this.root.sendKeys(new CharSequence[]{text});
        return this;
    }

    public class AdvancedTextInputInteractions {
        public TextInputComponentImpl clear(ClearType clearType) {
            int valueLength = TextInputComponentImpl.this.root.getAttribute("value").length();
            Actions builder = new Actions(TextInputComponentImpl.this.driver);
            switch (clearType) {
                case BACKSPACE: {
                    for (int i = 0; i < valueLength; ++i) {
                        builder.sendKeys(TextInputComponentImpl.this.root, new CharSequence[]{Keys.BACK_SPACE});
                    }
                    builder.build().perform();
                    break;
                }
                case DELETE: {
                    String ctrlADel = Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a", Keys.DELETE});
                    builder.sendKeys(TextInputComponentImpl.this.root, new CharSequence[]{ctrlADel});
                    builder.build().perform();
                    break;
                }
                case ESCAPE_SQ: {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < valueLength; ++i) {
                        sb.append("\b");
                    }
                    TextInputComponentImpl.this.root.sendKeys(new CharSequence[]{sb.toString()});
                    TextInputComponentImpl.this.root.click();
                    break;
                }
                case JS: {
                    Utils.jQ(TextInputComponentImpl.this.executor, "val('')", TextInputComponentImpl.this.root);
                    break;
                }
                case WD: {
                    TextInputComponentImpl.this.root.clear();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type of clear method " + (Object)((Object)clearType));
                }
            }
            return TextInputComponentImpl.this;
        }

        public TextInputComponentImpl focus() {
            TextInputComponentImpl.this.root.sendKeys(new CharSequence[]{""});
            return TextInputComponentImpl.this;
        }

        public WebElement getInputElement() {
            return TextInputComponentImpl.this.root;
        }

        public TextInputComponentImpl trigger(String event) {
            Utils.triggerJQ(TextInputComponentImpl.this.executor, event, TextInputComponentImpl.this.root);
            return TextInputComponentImpl.this;
        }
    }
}

