/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.hotkey;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.configuration.RichFacesPageFragmentsConfiguration;
import org.richfaces.fragment.configuration.RichFacesPageFragmentsConfigurationContext;
import org.richfaces.fragment.hotkey.Hotkey;

public class RichFacesHotkey
implements Hotkey,
AdvancedInteractions<AdvancedHotkeyInteractions> {
    @Drone
    private WebDriver driver;
    @Root
    private WebElement rootElement;
    @ArquillianResource
    private Actions actions;
    @FindBy(tagName="script")
    private WebElement script;
    private final RichFacesPageFragmentsConfiguration configuration = RichFacesPageFragmentsConfigurationContext.getProxy();
    private final AdvancedHotkeyInteractions interactions = new AdvancedHotkeyInteractions();
    private String hotkey;
    private String selector;

    @Override
    public AdvancedHotkeyInteractions advanced() {
        return this.interactions;
    }

    @Override
    public void invoke() {
        this.invoke(this.driver.findElement((By)this.advanced().getSelector().or((Object)Utils.BY_HTML)));
    }

    @Override
    public void invoke(WebElement element) {
        Preconditions.checkNotNull((Object)element);
        String hotkey = this.advanced().getHotkey();
        if (hotkey == null || hotkey.trim().isEmpty()) {
            throw new IllegalArgumentException("The hotkey can not be null nor empty! Set it up correctly with #setUp(String) method.");
        }
        this.actions.sendKeys(element, new CharSequence[]{hotkey}).perform();
    }

    @Override
    public void setupHotkey(String hotkey) {
        if (hotkey == null || hotkey.isEmpty()) {
            throw new IllegalArgumentException("Hotkey cannot be empty or null. Set up hotkey from widget if you want to reset it.");
        }
        this.hotkey = this.parseHotKey(hotkey);
    }

    @Override
    public void setupSelector(String selector) {
        if (selector == null || selector.isEmpty()) {
            throw new IllegalArgumentException("Selector cannot be empty or null.");
        }
        this.selector = selector;
    }

    private String parseHotKey(String input) {
        String result = "";
        String hotkeyTextTmp = input;
        EnumSet<ModifierKeys> keys = EnumSet.noneOf(ModifierKeys.class);
        for (ModifierKeys modifierKey : ModifierKeys.values()) {
            if (!hotkeyTextTmp.contains(modifierKey.toString().toLowerCase())) continue;
            keys.add(modifierKey);
            hotkeyTextTmp = hotkeyTextTmp.replaceAll(modifierKey.toString().toLowerCase(), "");
        }
        if ((hotkeyTextTmp = hotkeyTextTmp.replaceAll("\\+", "")).length() != 1) {
            throw new RuntimeException("Hotkey doesn't contain one character.");
        }
        for (ModifierKeys modifierKeys : keys) {
            result = result + modifierKeys.getKey();
        }
        if ((result = Keys.chord((CharSequence[])new CharSequence[]{result, hotkeyTextTmp})) == null || result.isEmpty()) {
            throw new RuntimeException("Hotkey cannot be empty or null.");
        }
        return result;
    }

    public class AdvancedHotkeyInteractions {
        private String previousKeyText = "";

        public String getHotkey() {
            if (RichFacesHotkey.this.configuration.isUseJSInteractionStrategy()) {
                this.setupFromWidget();
            }
            return RichFacesHotkey.this.hotkey;
        }

        public WebElement getRootElement() {
            return RichFacesHotkey.this.rootElement;
        }

        protected Optional<By> getSelector() {
            return RichFacesHotkey.this.selector == null || RichFacesHotkey.this.selector.isEmpty() ? Optional.absent() : Optional.of((Object)ByJQuery.selector((String)RichFacesHotkey.this.selector));
        }

        public void setupFromWidget() {
            this.setupHotkeyFromWidget();
            this.setupSelectorFromWidget();
        }

        public void setupHotkeyFromWidget() {
            Optional<String> hotkeyText = Utils.getComponentOption(RichFacesHotkey.this.rootElement, "key");
            if (!hotkeyText.isPresent()) {
                throw new NullPointerException("The hotkey value is null.");
            }
            if (this.previousKeyText.equals(hotkeyText.get())) {
                return;
            }
            RichFacesHotkey.this.setupHotkey((String)hotkeyText.get());
        }

        public void setupSelectorFromWidget() {
            RichFacesHotkey.this.selector = (String)Utils.getComponentOptionDocumentObjectSafe(RichFacesHotkey.this.rootElement, "selector").orNull();
        }
    }

    public static enum ModifierKeys {
        ALT(Keys.ALT),
        SHIFT(Keys.SHIFT),
        CTRL(Keys.CONTROL);

        private final Keys key;

        private ModifierKeys(Keys key) {
            this.key = key;
        }

        public Keys getKey() {
            return this.key;
        }
    }
}

