/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.inputNumberSlider;

import com.google.common.base.Preconditions;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.condition.element.WebElementConditionFactory;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedInteractions;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.inputNumberSlider.AbstractNumberInput;
import org.richfaces.fragment.inputNumberSlider.InputNumberSlider;

public class RichFacesInputNumberSlider
extends AbstractNumberInput
implements InputNumberSlider,
AdvancedInteractions<AdvancedInputNumberSliderInteractions> {
    @FindBy(className="rf-insl-inc")
    private WebElement arrowIncrease;
    @FindBy(className="rf-insl-dec")
    private WebElement arrowDecrease;
    @FindBy(css="span.rf-insl-inp-cntr > input.rf-insl-inp")
    private TextInputComponentImpl input;
    @FindBy(className="rf-insl-hnd-cntr")
    private WebElement handleContainer;
    @FindBy(className="rf-insl-hnd")
    private WebElement handle;
    @FindBy(className="rf-insl-hnd-dis")
    private WebElement disabledHandle;
    @FindBy(className="rf-insl-mn")
    private WebElement min;
    @FindBy(className="rf-insl-mx")
    private WebElement max;
    @FindBy(css="span.rf-insl-trc")
    private WebElement trackComponent;
    @FindBy(className="rf-insl-tt")
    private WebElement tooltip;
    @FindBy(css="span.rf-insl-trc")
    private WebElement sliderElement;
    @Drone
    private WebDriver browser;
    @Root
    private WebElement root;
    private final AdvancedInputNumberSliderInteractions advancedInteractons = new AdvancedInputNumberSliderInteractions();

    @Override
    public AdvancedInputNumberSliderInteractions advanced() {
        return this.advancedInteractons;
    }

    @Override
    public void slideToValue(double n) {
        this.advanced().dragHandleToPointInTrace((int)(n * (double)this.advanced().getWidth()));
    }

    private void scrollToView() {
        new Actions(this.browser).moveToElement(this.root).perform();
    }

    @Override
    protected WebElement getArrowIncreaseElement() {
        return this.arrowIncrease;
    }

    @Override
    protected WebDriver getBrowser() {
        return this.browser;
    }

    @Override
    protected WebElement getArrowDecreaseElement() {
        return this.arrowDecrease;
    }

    @Override
    protected TextInputComponentImpl getInput() {
        return this.input;
    }

    public class AdvancedInputNumberSliderInteractions
    extends AbstractNumberInput.AdvancedNumberInputInteractions {
        public void dragHandleToPointInTrace(int pixelInTrace) {
            Preconditions.checkArgument((pixelInTrace >= 0 && pixelInTrace <= this.getWidth() ? 1 : 0) != 0, (Object)"Cannot slide outside the trace.");
            if (!((Boolean)new WebElementConditionFactory(RichFacesInputNumberSlider.this.root).isVisible().apply((Object)RichFacesInputNumberSlider.this.browser)).booleanValue()) {
                throw new RuntimeException("Trace is not visible.");
            }
            RichFacesInputNumberSlider.this.scrollToView();
            Actions actions = new Actions(RichFacesInputNumberSlider.this.browser).clickAndHold(RichFacesInputNumberSlider.this.handle);
            actions.moveToElement(RichFacesInputNumberSlider.this.root, pixelInTrace, 0);
            actions.release(RichFacesInputNumberSlider.this.handle).build().perform();
        }

        public int getWidth() {
            return Utils.getLocations(RichFacesInputNumberSlider.this.handleContainer).getWidth();
        }

        public WebElement getRootElement() {
            return RichFacesInputNumberSlider.this.root;
        }

        public WebElement getDisabledHandleElement() {
            return RichFacesInputNumberSlider.this.disabledHandle;
        }

        public WebElement getHandleElement() {
            return RichFacesInputNumberSlider.this.handle;
        }

        public WebElement getMinimumElement() {
            return RichFacesInputNumberSlider.this.min;
        }

        public WebElement getMaximumElement() {
            return RichFacesInputNumberSlider.this.max;
        }

        public WebElement getTrackElement() {
            return RichFacesInputNumberSlider.this.trackComponent;
        }

        public WebElement getTooltipElement() {
            return RichFacesInputNumberSlider.this.tooltip;
        }

        public WebElement getSliderElement() {
            return RichFacesInputNumberSlider.this.sliderElement;
        }
    }
}

