/*
 * JBoss, Home of Professional Open Source
 * Copyright 2013, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.javascript.client.message;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import org.junit.Test;

import static org.junit.Assert.assertFalse;

/**
 * <p class="changed_added_4_0">
 * </p>
 *
 * @author asmirnov@exadel.com
 *
 */
public class ClearMessageTest extends MessageTestBase {
    private static final String ERROR_MESSAGE = "Error";

    @Test
    public void testClear() throws Exception {
        setUpMessage();
        sendMessage();
        HtmlElement htmlElement = getMessageContentElement();
        String text = htmlElement.asText();
        assertFalse(text.contains(ERROR_MESSAGE));
    }

    @Override
    protected String getMessageContent() {

        return "<span class='rf-msg-err'><span class='rf-msg-sum'>" + ERROR_MESSAGE + "</span><span>";
    }

    @Override
    protected String getJavaScriptFunctionName() {
        return "clearMessage";
    }
}
